% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProxyClass.R
\docType{class}
\name{ProxyFunction-class}
\alias{ProxyFunction-class}
\alias{ProxyFunction}
\title{A Class for Proxy Functions}
\description{
A class for functions in R that call functions in a server language.  The arguments in a call are converted to
equivalent server language objects, via \code{\link{asServerObject}()}.  These usually include proxy
objects in R for results previously computed through the same interface evaluator.
}
\details{
This class is always subclassed for a particular server language.  Proxy functions for that
language will use a corresponding evaluator to find metadata about the server function.
}
\section{Slots}{

\describe{
\item{\code{.Data}}{the function}

\item{\code{name}}{the name of the server language function}

\item{\code{module}}{the name of the module, if that needs to be imported}

\item{\code{evaluatorClass}}{the class for the evaluator, identifying which server lanaguage is involved.}

\item{\code{serverDoc}}{documentation for the server language function}

\item{\code{serverArgs}}{the formal arguments of the server language function, if known}
}}

\references{
Chambers, John M. (2016)
\emph{Extending R},
Chapman & Hall/CRC.
( Chapter 13, discussing this package, is included in the package: \url{../doc/Chapter_XR.pdf}.)
}
