% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJuliaConnect.R
\name{findJulia}
\alias{findJulia}
\title{Find a Julia Executable}
\usage{
findJulia(test = FALSE)
}
\arguments{
\item{test}{Should the function test for the existence of the application.  Default \code{FALSE}. Calling with
\code{TRUE} is useful to bullet-proof examples or tests for the absence of Julia. If the test search succeeds,
the location is saved in environment variable \code{JULIA_BIN}.}
}
\value{
The location as a character string, unless \code{test} is \code{TRUE}, in which case success or failure
is returned, and the location found (or the empty string) is saved as the environment varialbe.
If \code{test} is \code{FALSE}, failure to find a Julia
in the current system is an error.
}
\description{
This function looks for an executable Julia application in the local operating system.  The location can be prespecified by
setting environment variable \code{JULIA_BIN}; otherwise, the function looks in various conventional locations
and if that doesn't work, runs a shell command to look for \code{julia}.
}
\section{On Mac OS X}{

Installing Julia in the usual way does not put the command line version in a
standard location, but instead in a folder under \code{/Applications}.
Assuming one wants to have Julia available from the command line,
creating a symbolic link to it in \code{/usr/local/bin} is a standard approach.
If the current version of Julia is \code{0.6}:

\code{sudo ln -s /Applications/Julia-0.6.app/Contents/Resources/julia/bin/julia /usr/local/bin/julia}

If for some reason you did not want this to be available,  set the shell variable
\code{JULIA_BIN} to the first file in the command, the one in \code{/Applications}.
}

