% Generated by roxygen2 (4.0.1): do not edit by hand
\name{valid.arg.index}
\alias{valid.arg.index}
\title{Check validity of an index}
\usage{
valid.arg.index(obj, x, safe = TRUE)
}
\arguments{
\item{obj}{list}

\item{x}{index or name of an element}

\item{safe}{whether safe if an index is higher than the one of any named element}
}
\value{
numeric, the index.
Return numeric(0) if the name or the index does not exist or when the
index is invalid.
If \code{safe} is FALSE, any index is valid; if \code{safe} is TRUE,
an index is invalid when the indexed element is positionally after
another named element.
}
\description{
Check validity of an index of a \code{list} object.
}
\examples{
ll <- list(11,12,13,a=14,b=15,16,17,c=18,19)
valid.arg.index(ll,-1) # non-existing index
valid.arg.index(ll,0)  # non-existing index
valid.arg.index(ll,1)  # valid index
valid.arg.index(ll,2)  # valid index
valid.arg.index(ll,5)  # invalid index
valid.arg.index(ll,10) # non-existing index
valid.arg.index(ll,"a")# valid name
valid.arg.index(ll,"e")# non-existing name
valid.arg.index(ll,5,safe=FALSE) # still return the index
}
\author{
Xiaobei Zhao
}

