\inputencoding{utf8}
\HeaderA{plot.yourcast}{Plot generation tool for YourCast}{plot.yourcast}
%
\begin{Description}\relax
Creates graphics from yourcast output for each
geographical unit and prints to the device window or a .pdf file in
the specified directory
\end{Description}
%
\begin{Usage}
\begin{verbatim}
## S3 method for class 'yourcast'
plot(x, dpath=getwd(), dvlabel=NULL,
                          family="agetime",
                          args.matplot=list(),args.wireframe=list(),
                          time.insamp.obs=TRUE, time.insamp.predict=TRUE,
                          age.insamp.predict=TRUE,
                          threedim.insamp.predict=TRUE,
                          age.xlab=NULL, age.ylab=NULL,
                          time.xlab=NULL, time.ylab=NULL,
                          threedim.xlab=NULL, threedim.ylab=NULL,
                          threedim.zlab=NULL,
                          screen=list(z=-40, x=-60, y=0),
                          age.incl=NULL,
                          print="device",filename=NULL,...)
\end{verbatim}
\end{Usage}
%
\begin{Arguments}
\begin{ldescription}

\item[\code{x}] \code{\LinkA{yourcast}{yourcast}} output object

\item[\code{dpath}] String. Directory where \file{.pdf} outputs are
saved. Defaults to working directory if not specified. Will be
ignored if \code{print="device"}. Default: \code{getwd()}

\item[\code{dvlabel}] String. Description of dependent variable that will be
used as the main title for the plots. Default: \code{NULL}

\item[\code{family}] String. Specifies type of plot generated by the
function.  \code{"time"} creates a time series plot where each age
cohort is plotted separately on the device. \code{"age"} creates a
plot of forecasts on age where data from each each year is
plotted separately.  \code{"agetime"} creates a side-by-side
presentation of the \code{"age"} and \code{"time"} plots. Finally,
\code{"threedim"} creates a three-dimensional plot of the
information in the `"age"' and `"time"'
plots. Default: \code{"agetime"}

\item[\code{args.matplot}] List. A list of arguments (must be labeled) to be
passed to \code{matplot}. For example, if wanted to turn change line
weight, could add \code{args.matplot=list(lwd=2)}. Does not apply to
plots of family \code{threedim}. In most cases users will
have to launch \code{age} and \code{time} plots separately for this
feature to work well. Note that some arguments to \code{matplot}
such as \code{xlab} and \code{main} should be made as arguments to
\code{plot.yourcast}; they will be overwritten if found in
\code{args.matplot}. For the moment, \code{main} is specified via the
\code{dvlabel} argument.

\item[\code{args.wireframe}] List. A list of arguments (must be labeled) to be
passed to \code{wireframe}. This only applies to plots of the
\code{threedim} family. Note that some arguments to \code{wireframe}
such as \code{zlab} and \code{screen} should be made as arguments to
\code{plot.yourcast}; they will be overwritten if found in
\code{args.wireframe}.

\item[\code{time.insamp.obs}] Logical. For \code{"time"} and `time' plots in
\code{"agetime"} plots, specifies whether observed values should be
plotted within the range of years with observations for the
dependent variable. Default: \code{TRUE}

\item[\code{time.insamp.predict}] Logical. For \code{"time"} and `time'
plots in \code{"agetime"} plots, specifies whether
predicted values should be plotted within the range of years with
observations for the dependent variable. For \code{"time"} plots,
the default is to print both predicted and observed values; this
option merely removes predicted values from this range if set to
\code{FALSE}. Default: \code{TRUE}

\item[\code{age.insamp.predict}] Logical. For \code{"age"} plots and the
`age' plots of \code{"agetime"} plots, specifies whether
predicted values should be plotted within the range of years with
observations for the dependent variable. If set to
\code{FALSE}, predicted values are replaced by observed values in
this range.  Default: \code{TRUE}

\item[\code{threedim.insamp.predict}] Logical. For \code{"threedim"} plots,
specifies whether predicted values should be plotted within the
range of years with observations for the dependent variable. If set to
\code{FALSE}, predicted values are replaced by observed values in
this range.  Default: \code{TRUE}

\item[\code{age.xlab}] String. The label for the `x' axis of \code{"age"} plots
and the `age' plot of \code{"agetime"} plots. Will be ignored
if `age' plot not created. Default: \code{"Age"}

\item[\code{age.ylab}] String. The label for the `y' axis of \code{"age"} plots
and the `age' plot of \code{"agetime"} plots. Will be ignored
if `age' plot not created. Default: \code{"Forecasts"}

\item[\code{time.xlab}] String. The label for the `x' axis of \code{"time"}
plots and the `time' plot of \code{"agetime"} plots. Will be
ignored if `time' plot not created. Default: \code{"Time"}

\item[\code{time.ylab}] String. The label for the `y' axis of \code{"time"}
plots and the `time' plot of \code{"agetime"} plots. Will be
ignored if `time' plot not created. Default: \code{"Data and
    Forecasts"}

\item[\code{threedim.xlab}] String. The label for the `x' axis of
\code{"threedim"} plots. Will be ignored if `threedim' plot
not created.  Default: \code{"Year"}

\item[\code{threedim.ylab}] String. The label for the `y' axis of
\code{"threedim"} plots. Will be ignored if `threedim' plot
not created.  Default: \code{"Age"}

\item[\code{threedim.zlab}] String. The label for the `z' axis of
\code{"threedim"} plots. Will be ignored if `threedim' plot
not created.  Default: \code{"Forecasts"}

\item[\code{screen}] List. List with three elements `x', `y',
and `z' that rotate the viewing angle for three dimensional
plots. Argument ignored for all other plot types. 
Default: \code{list(z=-40, x=-60, y=0)}

\item[\code{age.incl}] Vector. If changed from \code{NULL}, subset of age groups
to be included in the time series plot. Ages should be specified in
the same way they are in the \code{index.code} argument to
\code{yourcast()}. Default: \code{NULL}

\item[\code{print}] String. Specifies whether graphical output should be
displayed sequentially on a device window (\code{"device"}) or saved
directly to a \file{.pdf} file in the \code{dpath} (\code{"pdf"}). 
Default: \code{"device"}

\item[\code{filename}] Vector of strings. If changed from \code{NULL}, provides
filenames for pdfs created from the graphical output for each
geographical area. The order of the labels should be the same as the
order of the areas in \code{dataobj\$data}. Filenames will be recycled
if the length of the vector is less than the number of areas.

\item[\code{...}] Arguments to be passed to par() for the purpose of setting
graphical parameters for the plotting functions. See
\code{help(par)} for more details. 

\end{ldescription}
\end{Arguments}
%
\begin{Details}\relax
Prints sequentially to the device or saves \file{.pdf} files
with the requested plot for each geographic unit in the sample. If
requested, \file{.pdf} files will be saved in a specified directory or
the working directory. Three-dimensional plots are created with the
\code{wireframe} function from the \code{lattice} library.  For space
considerations, axes are labeled with the numerical versions of the
`age' and `time' vectors regardless of whether
\code{A.names} and \code{T.names} are supplied to
\code{\LinkA{yourcast}{yourcast}}.

Plots are titled with the \code{dvlabel} and the \code{G.names}
dataframe if it was supplied to \code{\LinkA{yourcast}{yourcast}} in the
\code{dataobj}.  For example if \code{dvlabel="Respiratory
Infections"} and the geographic identifier for that region is matched
with \code{"Belize"}, the plot will be titled ``Respiratory Infections,
Belize''. One or both labels will be utilized by the function if available.

Axis labels can be changed with the appropriate \code{xlab},
\code{ylab}, and \code{zlab} arguments.

It is important to note that \code{plot.yourcast} will only work if
all cross sections within the same geographic unit are of the same
dimensions. If, for example, a cross section for one age group has
fewer yearly observations than another from the same group, these
missing years must be filled in with \code{NA}, even if they occur in
the beginning of the sample period. This does not hold across
geographic units, however.

Finally, \code{plot.yourcast} handles \code{"agetime"} plots differently
than the other families by opening a new device window for each new
plot. This is done so that the size of the device can be controlled to
keep the side-by-side plots from appearing distorted when launched. This
convenience makes it impossible to place multiple plots on the same
device, however. Users seeking to create 1x2, 2x2, 3x2, etc., plot
layouts for the purposes of comparison are advised to use the separate
\code{"age"} and \code{"time"} plot families and print each plot indivudally
to the device.

Below is some example code for a 2x2 plot layout with, in effect, two
`agetime' plots:
\begin{alltt}
  par(mfrow=c(2,2))
  plot(y.out1,family="age")
  plot(y.out1,family="time")
  plot(y.out2,family="age")
  plot(y.out2,family="time")
\end{alltt}

\end{Details}
%
\begin{Value}
Device windows with requested plots or \file{.pdf} files saved
in the \code{dpath}.  
\end{Value}
%
\begin{Author}\relax
Jon Bischof \email{jbischof@fas.harvard.edu}
\end{Author}
%
\begin{References}\relax
\url{http://gking.harvard.edu/yourcast}
\end{References}
%
\begin{SeeAlso}\relax
\code{\LinkA{yourcast}{yourcast}} function and documentation
(\code{help(yourcast)})
\end{SeeAlso}
