% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Powerful.R
\name{Powerful}
\alias{Powerful}
\alias{A001694}
\title{Powerful numbers}
\usage{
Powerful(n, Rmpfr = TRUE, PrecisionBits = 496)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{Rmpfr}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}

\item{PrecisionBits}{a positive integer for precision bits larger than 2.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A001694}{A001694}, a \emph{Powerful} number is a positive integer such that
for every prime \eqn{p} dividing the number, \eqn{p^2} also divides the number. First
6 powerful numbers are 1, 4, 8, 9, 16, 25.
}
\examples{
## generate first 20 Powerful numbers
first20 = Powerful(20)

## print without trailing 0's.
print(first20, drop0trailing = TRUE)

}
