% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrequencyTable.R
\name{FrequencyTable}
\alias{FrequencyTable}
\title{Generate a Frequency Distribution Table for Fish Length Data}
\arguments{
\item{data}{A numeric vector or data frame containing fish length measurements. If a data frame is
provided, the first numeric column will be selected.}

\item{bin_width}{(Optional) A numeric value specifying the bin width for class intervals. If not
provided, the bin width is automatically calculated using Sturges' (1926) formula.}
}
\value{
A data frame with two columns: \code{Upper_Length} representing the upper boundary of each
length class, and \code{Frequency} representing the count of observations within each class.
}
\description{
This function creates a frequency distribution table for fish length data, allowing
users to specify or calculate the ideal bin width based on Sturges' formula. The function returns
a data frame containing the upper boundary of each length class and its associated frequency.
}
\details{
The ideal bin width is calculated if not provided, based on Sturges' formula:
\deqn{\text{Bin Width} = \frac{\text{Range}}{\text{Number of Classes}}} where the number of classes
is determined as \eqn{1 + 3.322 \log_{10}(N)} for a dataset of size \eqn{N}.
}
\examples{
# Generate random fish length data
set.seed(123)
fish_lengths <- data.frame(Length = runif(2000, min = 5, max = 70))

# Create a frequency table with an automatically calculated bin width
FrequencyTable(data = fish_lengths$Length)

# Specify a bin width of 5 and generate a frequency table
FrequencyTable(data = fish_lengths$Length, bin_width = 5)
utils::data("ExData", package = "aLBI")

}
