% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WoodSurface.R
\docType{methods}
\name{WoodSurface}
\alias{WoodSurface}
\alias{WoodSurface,aRchi-method}
\title{Estimate the unrolled wood surface from a QSM}
\usage{
WoodSurface(aRchi, level = "Tree")

\S4method{WoodSurface}{aRchi}(aRchi, level = "Tree")
}
\arguments{
\item{aRchi}{a file of class aRchi}

\item{level}{text. The level at which the wood surface is computed. \code{Tree}, \code{branching_order} or \code{Axis}.}
}
\value{
a numeric or data.table. The wood surface in m2
}
\description{
Estimate the unrolled wood surface from a QSM by summing the area of all cylinders at several level of organization.
}
\examples{
# Read an aRchi file with at least a QSM.
file=system.file("extdata","Tree_1_aRchi.aRchi",package = "aRchi")
Tree1_aRchi=read_aRchi(file)
# Compute the wood surface at branching order level.
WoodSurface(Tree1_aRchi,level="branching_order")

}
