% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_segments.R
\name{canvas_segments}
\alias{canvas_segments}
\title{Paint Line Segments on Canvas}
\usage{
canvas_segments(colors, background = '#fafafa', n = 100, 
                p = 0.5, H = 0.1, size = 0.2)
}
\arguments{
\item{colors}{a character (vector) specifying the colors used for the line segments.}

\item{background}{a character specifying the color used for the background.}

\item{n}{the number of line segments to draw.}

\item{p}{probability of drawing a vectical line segment.}

\item{H}{scaling factor for the line segments.}

\item{size}{line width of the segments.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws many line segments on the canvas.
}
\examples{
\donttest{
set.seed(1)
canvas_segments(colors = 'black', background = '#fafafa')
}

}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
