% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_mandelbrot.R
\name{canvas_mandelbrot}
\alias{canvas_mandelbrot}
\title{Draw the Mandelbrot Set}
\usage{
canvas_mandelbrot(colors, iterations = 100, zoom = 1, left = -1.7, right = -0.2,
                   bottom = -0.2999, top = 0.8001, resolution = 500)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{iterations}{a positive integer specifying the number of iterations of the algorithm.}

\item{zoom}{a positive value specifying the amount of zoom to apply.}

\item{left}{a value specifying the minimum location on the x-axis.}

\item{right}{a value specifying the maximum location on the x-axis.}

\item{bottom}{a value specifying the minimum location on the y-axis.}

\item{top}{a value specifying the maximum location on the y-axis.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws the Mandelbrot set on the canvas.
}
\examples{
\donttest{
canvas_mandelbrot(colors = colorPalette("tuscany1"))
}

}
\references{
\url{https://en.wikipedia.org/wiki/Mandelbrot_set}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
