% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_recaman.R
\name{canvas_recaman}
\alias{canvas_recaman}
\title{Draw Recaman's Sequence}
\usage{
canvas_recaman(
  colors,
  background = "#fafafa",
  iterations = 100,
  start = 0,
  increment = 1,
  curvature = 1,
  angle = 0,
  size = 0.1,
  closed = FALSE
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{iterations}{the number of iterations of the algorithm.}

\item{start}{the starting point of the algorithm.}

\item{increment}{the increment of each step.}

\item{curvature}{the curvature of each line.}

\item{angle}{the angle at which to place the artwork.}

\item{size}{the size of the lines.}

\item{closed}{logical. Whether to plot a curve from the end of the sequence back to the starting point.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws Recaman's sequence on a canvas. The algorithm takes increasingly large steps backward on the positive number line, but if it is unable to it takes a step forward.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_recaman(colors = colorPalette("tuscany1"))
}

}
\references{
\url{https://mathworld.wolfram.com/RecamansSequence.html}
}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
