% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matEncode.R
\name{matEncode}
\alias{matEncode}
\title{Function to encode Correlated columns of alignment matrix with desired properties}
\usage{
matEncode(aliMat, pIndex, propDf)
}
\arguments{
\item{aliMat}{amino acid multiple sequence alignment in the form of a matrix}

\item{pIndex}{Amino acid property index to be encoded. It is the row number in the property data frame}

\item{propDf}{The amino acid property to analyse. It is row number in propertyDF data frame}
}
\value{
A matrix of input dimensions with amino acid alphabets replaced by amino acid properties of choice
}
\description{
Function to encode Correlated columns of alignment matrix with desired properties
}
\examples{
aliMatLoc <- system.file("extdata", "aliMat.rda", package = "aaSEA")
aliMat <- readRDS(aliMatLoc)
matEncode(aliMat = aliMat, pIndex = 1, propDf = "Cruciani" )
}
