\docType{data}
\name{BrookTrout}
\alias{BrookTrout}
\alias{BrookTrout2}
\title{Salmon Survival in the Presence of Brook Trout}
\format{\code{BrookTrout} is a data frame with 12 observations on the
following 4 variables.  \code{BrookTrout2} is a different summary of the
same study and gives survival rates for chinook in different years.
\describe{ \item{trout}{a factor with levels \code{absent} and
\code{present} indicating whether brook trout are absent or present in the
stream} \item{salmon.released}{a numeric vector of the total number
of salmon released} \item{salmon.surviving}{a numeric vector of the
number of salmon surviving} \item{proportion.surviving}{a numeric
vector of the proportion of salmon surviving} }}
\source{
  Levin, P.S., S. Achord, B.E. Fiest, and R.W. Zabel. 2002.
  Non-indigenous brook trout and the demise of Pacific
  salmon: a forgotten threat? \emph{Proceedings of the
  Royal Society of London, Series B, Biological Sciences}
  269: 1663-1670.
}
\description{
  Total numbers of salmon released (\code{salmon.released})
  and surviving (\code{salmon.surviving}) in 12 streams, 6
  with brook trout \code{present} and 6 with brook trout
  \code{absent}. The proportion of salmon surviving
  (\code{proportion.surviving}) is given for each stream.
}
\examples{
data(BrookTrout)
data(BrookTrout2)
str(BrookTrout)
str(BrookTrout2)

bwplot(proportion.surviving ~ trout, BrookTrout)

aggregate( proportion.surviving ~ trout, BrookTrout, FUN = favstats)
summary( proportion.surviving ~ trout, BrookTrout, fun = favstats)
}
\keyword{datasets}

