% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{Selection}
\alias{Selection}
\title{Data for Meta-analysis}
\format{A data frame with 814 observations on the following 8 variables.

\describe{ \item{species}{species investigated}
\item{traitname}{trait investigated}
\item{strength.of.selection}{strength of selection}
\item{sample.size}{size of sample} \item{authors}{authors of
publication} \item{year}{year of publication}
\item{journal}{journal of publication}
\item{volume.pages}{volume and pages} }}
\source{
Kingsolver, J.G., H.E. Hoekstra, J.M. Hoekstra, D. Berrigan, S.N.
Vignieri, C.E. Hill, A. Hoang, P. Gibert, and P. Beerli. 2001. The strength
of phenotypic selection in natural populations. \emph{The American
Naturalist} 157: 245-261.
}
\description{
Data for meta-analysis on the relationship between testosterone and
aggression.
}
\examples{
histogram(~ strength.of.selection, Selection,n=40)
table(Selection$species) -> s
table(s)
s[s>10] # most common species
table(Selection$traitname) -> t
table(t)
t[t>10] # most common traits
}
\keyword{datasets}

