% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_node_inla_glm.R
\name{calc.node.inla.glm}
\alias{calc.node.inla.glm}
\title{Fit a given regression using INLA}
\usage{
calc.node.inla.glm(
  child.loc,
  dag.m.loc,
  data.df.loc,
  data.dists.loc,
  ntrials.loc,
  exposure.loc,
  compute.fixed.loc,
  mean.intercept.loc,
  prec.intercept.loc,
  mean.loc,
  prec.loc,
  loggam.shape.loc,
  loggam.inv.scale.loc,
  verbose.loc
)
}
\arguments{
\item{child.loc}{index of current child node.}

\item{dag.m.loc}{dag as matrix.}

\item{data.df.loc}{data df,}

\item{data.dists.loc}{list of distributions.}

\item{ntrials.loc}{\code{rep(1,dim(data.df)[1])}.}

\item{exposure.loc}{\code{rep(1,dim(data.df)[1])}.}

\item{compute.fixed.loc}{TRUE.}

\item{mean.intercept.loc}{the prior mean for all the Gaussian additive terms for each node. INLA argument \code{control.fixed=list(mean.intercept=...)} and \code{control.fixed=list(mean=...)}.}

\item{prec.intercept.loc}{the prior precision for all the Gaussian additive term for each node. INLA argument \code{control.fixed=list(prec.intercept=...)} and \code{control.fixed=list(prec=...)}.}

\item{mean.loc}{the prior mean for all the Gaussian additive terms for each node. INLA argument \code{control.fixed=list(mean.intercept=...)} and \code{control.fixed=list(mean=...)}. Same as \code{mean.intercept.loc}.}

\item{prec.loc}{the prior precision for all the Gaussian additive term for each node. INLA argument \code{control.fixed=list(prec.intercept=...)} and \code{control.fixed=list(prec=...)}. Same as \code{prec.intercept.loc}.}

\item{loggam.shape.loc}{the shape parameter in the Gamma distribution prior for the precision in a Gaussian node. INLA argument \code{control.family=list(hyper = list(prec = list(prior="loggamma",param=c(loggam.shape, loggam.inv.scale))))}.}

\item{loggam.inv.scale.loc}{the inverse scale parameter in the Gamma distribution prior for the precision in a Gaussian node. INLA argument \code{control.family=list(hyper = list(prec = list(prior="loggamma",param=c(loggam.shape, loggam.inv.scale))))}.}

\item{verbose.loc}{FALSE to not print additional output.}
}
\value{
If INLA failed, FALSE or an error is returned. Otherwise, the direct output from INLA is returned.
}
\description{
Internal wrapper to INLA and are called from \code{fitAbn.bayes} and \code{buildScoreCache.bayes}.
}
\seealso{
Other Bayes: 
\code{\link{buildScoreCache}()},
\code{\link{calc.node.inla.glmm}()},
\code{\link{fitAbn}()},
\code{\link{getmarginals}()}
}
\concept{Bayes}
