% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decay_exponential.R
\name{decay_exponential}
\alias{decay_exponential}
\title{Negative exponential decay function}
\usage{
decay_exponential(decay_value)
}
\arguments{
\item{decay_value}{A \code{numeric} value.}
}
\value{
A \code{function} that converts travel time cost t_id into an impedance factor.
}
\description{
Returns a negative exponential impedance function to be used inside
\code{accessibility} functions.
}
\examples{
library(accessibility)

# Create an exponential impedance function
impedance <- decay_exponential(decay_value = 0.1)

impedance(t_ij = 20)
impedance(t_ij = 25)
impedance(t_ij = 35)

}
\seealso{
Other Impedance functions: 
\code{\link{decay_binary}()},
\code{\link{decay_linear}()},
\code{\link{decay_power}()}
}
\concept{Impedance functions}
