% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_fulltext_update.R
\name{fulltext_update}
\alias{fulltext_update}
\title{Update full texts}
\usage{
fulltext_update(x, mode = "fulltext", updateX = TRUE)
}
\arguments{
\item{x}{Corpus object.}

\item{mode}{Character string; Which full text should be created; accepts the following values: fulltext.bytier, fulltext.bytime, fulltext;}

\item{updateX}{Logical; If \code{TRUE} the original corpus object passed as x to the function will also be updated! If you do not want this, set to \code{FALSE}.}
}
\value{
Corpus object.
}
\description{
Creates/updates the full texts of the transcripts in a corpus.
The full text may be created in two different ways: 
- The contents of a transcription will be joined consecutively based on the time information. 
- The contents of each tier will be joined consecutively, and then the next tier will be joined.
}
\examples{
library(act)

examplecorpus<-act::fulltext_update(x=examplecorpus)

}
