% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media_assign.R
\name{media_assign}
\alias{media_assign}
\title{Assign media file links to transcript objects}
\usage{
media_assign(
  x = NULL,
  filterFile = "*\\\\.(wav|mp3|aif|aiff|mp4)",
  searchFolder = NULL,
  searchInSubfolders = TRUE,
  filterTranscript = NULL,
  removeExistingMedia = TRUE,
  onlyUniqueFiles = TRUE
)
}
\arguments{
\item{x}{Corpus object.}

\item{filterFile}{Character string; regular expression of file types to look for.}

\item{searchFolder}{Character string; folder in which media files should be searched (if \code{NULL} the folder specified in \code{x@folders.media} will be used).}

\item{searchInSubfolders}{Logical; if \code{FALSE} only the main level of the directory will be scanned for media, if \code{TRUE} sub folders will be scanned for media, too.}

\item{filterTranscript}{Character string; search media files only for  transcripts that match the regular expression.}

\item{removeExistingMedia}{Logical; if \code{TRUE} existing media links will be removed, if \code{FALSE} existing media links will be preserved and new links will be added.}

\item{onlyUniqueFiles}{Logical; if \code{TRUE} media files with the same name (in different locations) will only be added once; if \code{FALSE} all media files found will be added, irrespective of possible doublets.}
}
\value{
Corpus object.
}
\description{
Searches for media files in folders and assigns the links to transcript objects in a corpus. 
The function uses the name of the transcript to find the media files, 
e.g. the function assumes that the annotation files have the same name as the media files, except from the suffix/the file type.
}
\examples{
library(act)

# Set the folder(s) where your media files are located in the corpus object
# Please be aware that that the example corpus that comes with the package
# does NOT contain media files. Please download the entire example corpus
# with media files if you want to use this function reasonably.
examplecorpus@folders.media <- c("", "")

examplecorpus <- act::media_assign(examplecorpus)

}
\seealso{
\link{media_remove}, \link{media_getpath}
}
