% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_data_replace_copy.R
\name{modify_data_replace_copy}
\alias{modify_data_replace_copy}
\title{Search, replace and copy the contents of annotations}
\usage{
modify_data_replace_copy(
  x,
  pattern,
  replacement = NA,
  destTier = "",
  filterTranscriptsInclude = "",
  filterTiersInclude = "",
  collapseString = " | "
)
}
\arguments{
\item{x}{Corpus object.}

\item{pattern}{Character string; search pattern as regular expression.}

\item{replacement}{Character string; replacement.}

\item{destTier}{Character string; name of the tier to which the hit should be copied (if no copying is intended set to "").}

\item{filterTranscriptsInclude}{Character string; filter as a regular expression, in which transcripts should be searched.}

\item{filterTiersInclude}{Character string; filter as a regular expression, in which tiers should be searched.}

\item{collapseString}{Character string; will be used to collapse multiple search results into one string.}
}
\value{
Corpus object.
}
\description{
The function searches within the contents of annotations and replaces the search hits. 
In addition the search hit may be copied to another tier. 
In case that there is no overlapping annotation in the destination tier a new annotation will be created (based on the time values of the original annotation). In case that there is an overlapping annotation in the destination tier, the search result will be added at the end.
}
\examples{
library(act)

# Have a look at the first transcript in the examplecorpus:
printtranscript <- act::snippets_printtranscript(examplecorpus@transcripts[[1]])
cat(stringr::str_c(printtranscript, sep="\n", collapse = "\n"))
# In line 01 there is the word "UN".

# Replace this word by "XXX" in the entire corpus
test <- act::modify_data_replace_copy(x=examplecorpus,
									  pattern="\\\\bUN\\\\b",
									  replacement="XXX")

# Have a look at the first transcript in the corprus object test:
printtranscript <- act::snippets_printtranscript(test@transcripts[[1]])
cat(stringr::str_c(printtranscript, sep="\n", collapse = "\n"))
# In line 01 there is now "XXX" instead of "UN"


# Insert a tier called "newTier" into all transcripts in the corpus:
for (t in examplecorpus@transcripts) {
	sortVector <- c(names(t@tiers), "newTier")
	examplecorpus <- act::modify_tiers_reorder (x=examplecorpus,
	sortVector=sortVector,
	filterTranscriptsInclude=t@name,
	addMissingTiers=TRUE)
}
# Check that the first transcript now contains the newTier
examplecorpus@transcripts[[1]]@tiers

# Now replace "UN" by "YYY" in the entire corpus and
# copy the search hit to "newTier".
test <- act::modify_data_replace_copy(x=examplecorpus,
									  pattern="\\\\bUN\\\\b",
									  replacement="YYY",
									  destTier = "newTier")

# Have a look again at the first transcript in the corpus object test.
printtranscript <- act::snippets_printtranscript(test@transcripts[[1]])
cat(stringr::str_c(printtranscript, sep="\n", collapse = "\n"))
# In line 01 you see that "UN" has been replaced by "YYY.
# In line 02 you see that it has been copied to the tier "newTier".


# If you only want to copy a search hit but not replace it in the original
# leave replacement="", which is the default
test <- act::modify_data_replace_copy(x=examplecorpus,
									  pattern="\\\\bUN\\\\b",
									  destTier = "newTier")
printtranscript <- act::snippets_printtranscript(test@transcripts[[1]])
cat(stringr::str_c(printtranscript, sep="\n", collapse = "\n"))
# In line 01 you see that "UN" has been maintained.
# In line 02 you see that "UN" it has been copied to the tier "newTier".

 
}
