% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcripts_filter.R
\name{transcripts_filter}
\alias{transcripts_filter}
\title{Filter all transcripts in a corpus}
\usage{
transcripts_filter(
  x,
  filterTranscriptNames = NULL,
  filterOnlyTheseTranscripts = NULL,
  filterTierNames = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL,
  preserveTimes = TRUE,
  sort = c("none", "tier>startSec", "startSec>tier")
)
}
\arguments{
\item{x}{Corpus object;}

\item{filterTranscriptNames}{Vector of character strings; names of transcripts to remain in the transcripts. If left unspecified, all transcripts will  remain in the transcripts.}

\item{filterOnlyTheseTranscripts}{Vector of character strings; names of transcripts to which filters will be applied. If left unspecified, all transcripts will be filtered.}

\item{filterTierNames}{Vector of character strings; names of tiers to remain in the transcripts. If left unspecified, all tiers will remain in the transcripts.}

\item{filterSectionStartsec}{Double, start of selection in seconds.}

\item{filterSectionEndsec}{Double, end of selection in seconds.}

\item{preserveTimes}{Logical; Parameter is used if \code{filterSectionStartsec} it set. If \code{TRUE} start times will be preserved, if \code{FALSE} the selection will start from 0.}

\item{sort}{Logical; Annotations will be sorted: 'none' (=no sorting), 'tier>startSec' (=sort first by tier, then by startSec), 'startSec>tier' (=sort first by startSec, then by tier)}
}
\value{
Corpus object;
}
\description{
Filter all transcript objects in a corpus and return the filtered corpus object.
It is possible to filter out temporal sections and tiers.
In case that you want to select tiers by using regular expressions use the function \code{act::search_meta} first.
}
\examples{
library(act)

# Filter corpus to only contain some tiers
all.tier.names <- unique(act::tiers_all(examplecorpus)$name)
some.tier.names <- all.tier.names[1:10]
x <- act::transcripts_filter(examplecorpus, filterTierNames=some.tier.names)
x@history[[length(x@history)]]
}
