% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_textgrid.R
\name{export_textgrid}
\alias{export_textgrid}
\title{Export a transcript object to a 'Praat' .TextGrid file}
\usage{
export_textgrid(
  t,
  outputPath = NULL,
  filterTierNames = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL
)
}
\arguments{
\item{t}{Transcript object; transcript to be saved.}

\item{outputPath}{Character string; path where .TextGrid will be saved.}

\item{filterTierNames}{Vector of character strings; names of tiers to be included. If left unspecified, all tiers will be exported.}

\item{filterSectionStartsec}{Double; start of selection in seconds.}

\item{filterSectionEndsec}{Double; end of selection in seconds.}
}
\value{
Contents of the .TextGrid file (only if \code{outputPath} is left empty)
}
\description{
Advice: In most situations it is more convenient to use \code{act::corpus_export} for exporting annotation files.
}
\details{
The .TextGrid file will be written to the file specified in \code{outputPath}.
If \code{outputPath} is left empty, the function will return the contents of the .TextGrid itself.
}
\examples{
library(act)

# Get the transcript you want to export
t <- examplecorpus@transcripts[[1]]

# Create temporary file path
path <- tempfile(pattern = t@name, tmpdir = tempdir(),
                 fileext = ".TextGrid")

# It makes more sense, however, to you define a destination folder
# that is easier to access on your computer:
\dontrun{
path <- file.path("PATH_TO_AN_EXISTING_FOLDER_ON_YOUR_COMPUTER",
                    paste(t@name, ".TextGrid", sep=""))
}

# Export
act::export_textgrid(t=t, outputPath=path)

}
\seealso{
\code{corpus_export}, \code{export_eaf}, \code{export_exb}, \code{export_printtranscript}, \code{export_rpraat}, \code{export_srt}
}
