% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_new.R
\name{search_new}
\alias{search_new}
\title{Create a new search}
\usage{
search_new(
  x,
  pattern,
  searchMode = c("content", "fulltext", "fulltext.byTime", "fulltext.byTier"),
  searchNormalized = TRUE,
  name = "mysearch",
  resultidprefix = "result",
  filterTranscriptNames = NULL,
  filterTranscriptIncludeRegEx = NULL,
  filterTranscriptExcludeRegEx = NULL,
  filterTierNames = NULL,
  filterTierIncludeRegEx = NULL,
  filterTierExcludeRegEx = NULL,
  filterSectionStartsec = NULL,
  filterSectionEndsec = NULL,
  concordanceMake = TRUE,
  concordanceWidth = NULL,
  cutSpanBeforesec = 0,
  cutSpanAftersec = 0,
  runSearch = TRUE
)
}
\arguments{
\item{x}{Corpus object; basis in which will be searched.}

\item{pattern}{Character string; search pattern as regular expression.}

\item{searchMode}{Character string; takes the following values: \code{content}, \code{fulltext} (=default, includes both full text modes), \code{fulltext.byTime}, \code{fulltext.byTier}.}

\item{searchNormalized}{Logical; if \code{TRUE} function will search in the normalized content, if \code{FALSE} function will search in the original content.}

\item{name}{Character string; name of the search. Will be used, for example, as name of the sub folder when creating media cuts.}

\item{resultidprefix}{Character string; prefix for the name of the consecutively numbered search results.}

\item{filterTranscriptNames}{Vector of character strings; names of transcripts to be included.}

\item{filterTranscriptIncludeRegEx}{Character string; as regular expression, limit search to certain transcripts matching the expression.}

\item{filterTranscriptExcludeRegEx}{Character string; as regular expression, exclude certain transcripts matching the expression.}

\item{filterTierNames}{Vector of character strings; names of tiers to be included.}

\item{filterTierIncludeRegEx}{Character string; as regular expression, limit search to certain tiers matching the expression.}

\item{filterTierExcludeRegEx}{Character string; as regular expression, exclude certain tiers matching the expression.}

\item{filterSectionStartsec}{Double; start time of region for search.}

\item{filterSectionEndsec}{Double; end time of region for search.}

\item{concordanceMake}{Logical; if \code{TRUE} concordance will be added to search results.}

\item{concordanceWidth}{Integer; number of characters  to the left and right of the search hit in the concordance , the default is \code{120}.}

\item{cutSpanBeforesec}{Double; Start the media and transcript cut some seconds before the hit to include some context, the default is \code{0}.}

\item{cutSpanAftersec}{Double; End the media and transcript cut some seconds before the hit to include some context, the default is \code{0}.}

\item{runSearch}{Logical; if \code{TRUE} search will be run in corpus object, if \code{FALSE} only the search object will be created.}
}
\value{
Search object.
}
\description{
Creates a new search object and runs the search in a corpus object.
Only 'x' and 'pattern' are obligatory. 
The other arguments can be left to their default values.
}
\examples{
library(act)

# Search for the 1. Person Singular Pronoun in Spanish.
mysearch <- act::search_new(examplecorpus, pattern= "yo")
mysearch
# Search in normalized content vs. original content
mysearch.norm  <- act::search_new(examplecorpus, pattern="yo", searchNormalized=TRUE)
mysearch.org   <- act::search_new(examplecorpus, pattern="yo", searchNormalized=FALSE)
mysearch.norm@results.nr
mysearch.org@results.nr

# The difference is because during normalization capital letters will be converted
# to small letters. One annotation in the example corpus contains a "yo" with a
# capital letter:
mysearch <- act::search_new(examplecorpus, pattern="yO", searchNormalized=FALSE)
mysearch@results$hit

# Search in full text vs. original content.
# Full text search will find matches across annotations.
# Let's define a regular expression with a certain span.
# Search for the word "no" 'no' followed by a "pero" 'but'
# in a distance ranging from 1 to 20 characters.
myRegEx <- "\\\\bno\\\\b.{1,20}pero"
mysearch <- act::search_new(examplecorpus, pattern=myRegEx, searchMode="fulltext")
mysearch
mysearch@results$hit

}
\seealso{
\link{search_run}, \link{search_makefilter}, \link{search_sub}
}
