% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotDetections}
\alias{plotDetections}
\title{Plot detections for a single tag}
\usage{
plotDetections(
  input,
  tag,
  type = c("stations", "arrays"),
  title,
  xlab,
  ylab,
  col,
  array.alias,
  frame.warning = TRUE
)
}
\arguments{
\item{input}{The results of an actel analysis (either explore, migration or residency).}

\item{tag}{The transmitter to be plotted.}

\item{type}{The type of y axis desired. One of "stations" (default) or "arrays".}

\item{title}{An optional title for the plot. If left empty, a default title will be added.}

\item{xlab, ylab}{Optional axis names for the plot. If left empty, default axis names will be added.}

\item{col}{An optional colour scheme for the detections. If left empty, default colours will be added.}

\item{array.alias}{A named vector of format c("old_array_name" = "new_array_name") to replace
default array names with user defined ones.}

\item{frame.warning}{Logical. By default, actel highlights manually changed or overridden tags in yellow
and red plot frames, respectively. Set to FALSE to deactivate this behaviour.}
}
\value{
A ggplot object.
}
\description{
The output of plotDetections is a ggplot object, which means you can then use it in combination
with other ggplot functions, or even together with other packages such as patchwork.
}
\examples{
# Using the example results that come with actel
plotDetections(example.results, 'R64K-4451')

# Because plotDetections returns a ggplot object, you can store
# it and edit it manually, e.g.:
library(ggplot2)
p <- plotDetections(example.results, 'R64K-4451')
p <- p + xlab("changed the x axis label a posteriori")
p

# You can also save the plot using ggsave!

}
