% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activity_code.r
\name{gettime}
\alias{gettime}
\title{Convert time of day data to numeric}
\usage{
gettime(
  x,
  scale = c("radian", "hour", "proportion"),
  ...,
  tryFormats = c("\%Y-\%m-\%d \%H:\%M:\%OS", "\%Y/\%m/\%d \%H:\%M:\%OS",
    "\%Y:\%m:\%d \%H:\%M:\%OS", "\%Y-\%m-\%d \%H:\%M", "\%Y/\%m/\%d \%H:\%M",
    "\%Y:\%m:\%d \%H:\%M", "\%Y-\%m-\%d", "\%Y/\%m/\%d", "\%Y:\%m:\%d")
)
}
\arguments{
\item{x}{A vector of POSIXct, POSIXlt or character format time data to convert.}

\item{scale}{The scale on which to return times (see Value for options).}

\item{...}{arguments passed to as.POSIXlt}

\item{tryFormats}{formats to try when converting date from character, passed to as.POSIXlt}
}
\value{
A vector of numeric times of day in units defined by the \code{scale} argument:
radian, on the range [0, 2*pi];
hours, on the range [0, 24];
proportion, on the range [0, 1].
}
\description{
Accepts data of class POSIXct, POSIXlt or character and returns the  time of day element as numeric (any date element is ignored).
}
\examples{
data(BCItime)
rtime <- gettime(BCItime$date)
htime <- gettime(BCItime$date, "hour")
ptime <- gettime(BCItime$date, "proportion")
summary(rtime)
summary(htime)
summary(ptime)
}
\seealso{
\code{\link{strptime}}
}
