% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/APDfunctions.R
\name{GCMMpdens}
\alias{GCMMpdens}
\title{Predict activity probability density at a time point}
\usage{
GCMMpdens(model, timepoint, HDI = TRUE, sample = 1000, scale = "2pi")
}
\arguments{
\item{model}{Object of class \code{GCMM} with output from \code{\link{GCMM}} function}

\item{timepoint}{Time point for which to predict activity probability density}

\item{HDI}{Logical argument for whether to calculate 95\% HDI; default=TRUE}

\item{sample}{Number of posterior samples from which to build HDI; default=1000}

\item{scale}{Scale of the data, either "2pi" for 0,2pi or "pi" for -pi,pi; default="2pi"}
}
\value{
Returns numeric vector of estimated probability density if HDI=FALSE or posterior probability distribution if HDI=TRUE
}
\description{
Calculates predicted activity probability density from GCMM model at a specific time point
}
