% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCMMplots.R
\name{componentsplot}
\alias{componentsplot}
\title{GCMM Components Plot}
\usage{
componentsplot(
  model,
  rug = FALSE,
  ruglwd = 2,
  lwd = 3,
  col = c("black", "grey40", "grey60", "grey80"),
  scale = "NULL",
  ymax = "NULL",
  lty = 1,
  axisunits = c("radians", "sun", "solar", "time", "none"),
  xlines = TRUE
)
}
\arguments{
\item{model}{Model output from \code{\link{GCMM}} function, object of class \code{GCMM}}

\item{rug}{Logical argument for whether to plot a rug of the raw values. Plotting the rug for the separate components requires that saveclustIDs=TRUE when running GCMM. default=FALSE}

\item{ruglwd}{Line width for rug plot}

\item{lwd}{Line width for activity curve lines}

\item{col}{Character vector for colours for the activity curve lines and rug plot; must be of equal length to the number of components}

\item{scale}{Scale for the plot, either "pi" (-pi, pi) or "2pi" (0, 2pi); default is that recommended by the GCMM function}

\item{ymax}{Value for upper limit of y-axis}

\item{lty}{Line type for activity curve}

\item{axisunits}{Scale to use for the xaxis, either "radians", "time", "solar", "sun", or "none"; default="radians"}

\item{xlines}{Whether to include lines on the graph for the x axis labels; default=TRUE}
}
\value{
Plot of the separate components of the circular mixture model
}
\description{
Plot of activity curves for the separate components in the circular mixture model
}
\examples{
\donttest{ FoxActivityGCMM<-GCMM(data=redfoxsample$Radians, 
           RE1=redfoxsample$SamplingPeriod, family="vonmises", autorun=FALSE,
           adapt=0, sample=300, burnin=300, thin=1,n.chains=2)
        componentsplot(FoxActivityGCMM) }
 
}
