\name{activpal.file.reader}
\alias{activpal.file.reader}
\title{Read in activPAL Events File
}
\description{This function reads in the events file generated by the activPAL software.  Some AP events files use julian time with the origin month=12,day=30,year=1899.  This function converts julian time to "\%Y-\%m-\%d \%H:\%M:\%S" format 
}
\usage{
activpal.file.reader(file.name.and.path)
}
\arguments{
  \item{file.name.and.path}{character string identifying the path to the file of interest
}
}
\value{
A data frame with 6 columns identical to events file.  Columns are renamed: 1) time=Time, 2) datacount=DataCount (samples), 3) interval=Interval (s), 4) activity=ActivityCode (0-sedentary, 1=standing, 2=stepping), 5) cumulativesteps=CumulativeStepCount, and 6) methrs=Activity Score (MET.h)
}
\author{John Staudenmayer
}

\examples{
\dontrun{
activpal.file.reader("/Users/jsmith/Documents/...")
activpal.file.reader("C:/Documents and Settings/...")
}
}


\keyword{activpal}
\keyword{events}