% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{fixef-actuaRE}
\alias{fixef-actuaRE}
\alias{fixef.hierCredGLM}
\alias{fixef.hierCredTweedie}
\title{Extract the fixed-effects estimates from a fitted random effects model}
\usage{
\method{fixef}{hierCredGLM}(object, ...)

\method{fixef}{hierCredTweedie}(object, ...)
}
\arguments{
\item{object}{an object of type \code{\link{hierCredGLM}} or \code{\link{hierCredTweedie}}}

\item{...}{ignored.}
}
\value{
a named, numeric vector of fixed-effects estimates.
}
\description{
A generic function to extract the fixed effects (i.e. the company-specific effects) estimates from a fitted random effects model.
}
\examples{
\donttest{
fit = hierCredGLM(Y ~ area + (1 | VehicleType / VehicleBody), dataCar,
weights = w, p = 1.75, epsilon = 1e-6)
fixef(fit)
}
}
