\name{GammaMoments}
\alias{GammaMoments}
\alias{mgamma}
\alias{levgamma}
\title{Raw and Limited Moments of the Gamma Distribution}
\description{
  Raw moments and limited moments for the Gamma distribution with
  parameters \code{shape} and \code{scale}.
}
\usage{
  mgamma(order, shape, rate = 1, scale = 1/rate)
  levgamma(limit, shape, rate = 1, scale = 1/rate, order = 1)
}
\arguments{
  \item{order}{order of the moment.}
  \item{limit}{limit of the loss variable.}
  \item{rate}{an alternative way to specify the scale.}
  \item{shape, scale}{shape and scale parameters. Must be strictly
    positive.}
}
\details{
  The \eqn{k}th raw moment of the random variable \eqn{X} is
  \eqn{E[X^k]}{E[X^k]} and the \eqn{k} limited moment at some limit
  \eqn{d} is \eqn{E[\min(X, d)]}{E[min(X, d)]}.
}
\value{
  \code{mgamma} gives the \eqn{k}th raw moment and
  \code{levgamma} gives the \eqn{k}th moment of the limited loss
  variable.

  Invalid arguments will result in return value \code{NaN}, with a warning.
}
\seealso{
  \code{\link{GammaDist}} for details on the Gamma distribution and
  functions \code{{d,p,q,r}gamma}.
}
\references{
  Klugman, S. A., Panjer, H. H. and Willmot, G. E. (2004),
  \emph{Loss Models, From Data to Decisions, Second Edition}, Wiley.
}
\author{
  Vincent Goulet \email{vincent.goulet@act.ulaval.ca} and
  Mathieu Pigeon
}
\examples{
mgamma(2, 3, 4) - mgamma(1, 3, 4)^2
levgamma(10, 3, 4, order = 2)
}
\keyword{distribution}
