% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{ada_set_href}
\alias{ada_set_href}
\alias{ada_set_username}
\alias{ada_set_password}
\alias{ada_set_port}
\alias{ada_set_host}
\alias{ada_set_hostname}
\alias{ada_set_pathname}
\alias{ada_set_protocol}
\alias{ada_set_search}
\alias{ada_set_hash}
\title{Set a specific component of URL}
\usage{
ada_set_href(url, input, decode = TRUE)

ada_set_username(url, input, decode = TRUE)

ada_set_password(url, input, decode = TRUE)

ada_set_port(url, input, decode = TRUE)

ada_set_host(url, input, decode = TRUE)

ada_set_hostname(url, input, decode = TRUE)

ada_set_pathname(url, input, decode = TRUE)

ada_set_protocol(url, input, decode = TRUE)

ada_set_search(url, input, decode = TRUE)

ada_set_hash(url, input, decode = TRUE)
}
\arguments{
\item{url}{character. one or more URL to be parsed}

\item{input}{character. containing new component for URL. Vector of length 1
or same length as url.}

\item{decode}{logical. Whether to decode the output (see \code{\link[utils:URLencode]{utils::URLdecode()}}), default to \code{TRUE}}
}
\value{
character, \code{NA} if not a valid URL
}
\description{
These functions set a specific component of URL.
}
\examples{
url <- "https://user_1:password_1@example.org:8080/dir/../api?q=1#frag"
ada_set_href(url, "https://google.de")
ada_set_username(url, "user_2")
ada_set_password(url, "hunter2")
ada_set_port(url, "1234")
ada_set_hash(url, "#section1")
ada_set_host(url, "example.de")
ada_set_hostname(url, "example.de")
ada_set_pathname(url, "path/")
ada_set_search(url, "q=2")
ada_set_protocol(url, "ws:")
}
