% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ada.R
\name{do_ada}
\alias{do_ada}
\title{Run the whole classical archetypoid analysis with the Frobenius norm}
\usage{
do_ada(subset, numArchoid, numRep, huge, compare = FALSE,
              vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
              outl_degree = c("outl_strong", "outl_semi_strong", "outl_moderate"),
              method = "adjbox")
}
\arguments{
\item{subset}{Data to obtain archetypes. In ADALARA this is a subset of the 
entire data frame.}

\item{numArchoid}{Number of archetypes/archetypoids.}

\item{numRep}{For each \code{numArch}, run the archetype algorithm \code{numRep} times.}

\item{huge}{Penalization added to solve the convex least squares problems.}

\item{compare}{Boolean argument to compute the robust residual sum of squares 
to compare these results with the ones provided by \code{\link{do_ada_robust}}.}

\item{vect_tol}{Vector the tolerance values. Default c(0.95, 0.9, 0.85).
Needed if \code{method='toler'}.}

\item{alpha}{Significance level. Default 0.05. Needed if \code{method='toler'}.}

\item{outl_degree}{Type of outlier to identify the degree of outlierness.
Default c("outl_strong", "outl_semi_strong", "outl_moderate").
Needed if \code{method='toler'}.}

\item{method}{Method to compute the outliers. Options allowed are 'adjbox' for
using adjusted boxplots for skewed distributions, and 'toler' for using
tolerance intervals.}
}
\value{
A list with the following elements:
\itemize{
\item cases: Final vector of archetypoids.
\item alphas: Alpha coefficients for the final vector of archetypoids.
\item rss: Residual sum of squares corresponding to the final vector of archetypoids.
\item rss_rob: If \code{compare=TRUE}, this is the residual sum of squares using
the robust Frobenius norm. Otherwise, NULL.
\item resid: Vector with the residuals.
\item outliers: Outliers.
}
}
\description{
This function executes the entire procedure involved in the archetypoid analysis.
Firstly, the initial vector of archetypoids is obtained using the archetypal 
algorithm and finally, the optimal vector of archetypoids is returned.
}
\examples{
library(Anthropometry)
data(mtcars)
#data <- as.matrix(mtcars)
data <- mtcars

k <- 3
numRep <- 2
huge <- 200

preproc <- preprocessing(data, stand = TRUE, percAccomm = 1)
set.seed(2018)
res_ada <- do_ada(preproc$data, k, numRep, huge, FALSE, method = "adjbox")
str(res_ada)     

res_ada1 <- do_ada(preproc$data, k, numRep, huge, FALSE, 
                   vect_tol = c(0.95, 0.9, 0.85), alpha = 0.05, 
                   outl_degree = c("outl_strong", "outl_semi_strong", 
                                   "outl_moderate"), method = "toler")
str(res_ada1) 
                 
}
\seealso{
\code{\link{stepArchetypesRawData_norm_frob}}, \code{\link{archetypoids_norm_frob}}
}
\author{
Guillermo Vinue
}
