% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivegpca-package.R
\name{processPhyloseq}
\alias{processPhyloseq}
\title{Make the input matrices for adaptive gPCA}
\usage{
processPhyloseq(physeq, ca = FALSE)
}
\arguments{
\item{physeq}{A \code{\link[phyloseq]{phyloseq}} object, from the
phyloseq package.}

\item{ca}{If TRUE, do the normalization as for correspondence
analysis (transform counts to relative abundances, compute sample
weights, center the relative abundances according to the sample
weights). Otherwise, simply center the data.}
}
\value{
A list of the matrix to perform adaptive gPCA on
(\code{X}), the species similarity matrix (\code{Q}), and the
sample weights (\code{weights}).
}
\description{
Takes a phyloseq object and creates the matrices necessary to do
adaptive gPCA.
}
\examples{
data(AntibioticPhyloseq)
pp = processPhyloseq(AntibioticPhyloseq)
}
