% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_cluster.R
\name{setup_cluster}
\alias{setup_cluster}
\title{Setup default cluster for use in parallelised adaptr functions}
\usage{
setup_cluster(cores, export = NULL, export_envir = parent.frame())
}
\arguments{
\item{cores}{can be either unspecified, \code{NULL}, or a single integer \verb{> 0}. If
\code{NULL} or \code{1}, an existing default cluster is removed (if any), and the
default will subsequently be to run functions sequentially in the main
process if \code{cores = 1}, and according to \code{getOption("mc.cores")} if \code{NULL}
(unless otherwise specified in individual functions calls). The
\code{\link[parallel:detectCores]{parallel::detectCores()}} function may be used to see the number of
available cores, although this comes with some caveats (as described in the
function documentation), including that the number of cores may not always
be returned and may not match the number of cores that are available for
use. In general, using less cores than available may be preferable if other
processes are run on the machine at the same time.}

\item{export}{character vector of names of objects to export to each
parallel core when running in parallel; passed as the \code{varlist} argument to
\code{\link[parallel:clusterApply]{parallel::clusterExport()}}. Defaults to \code{NULL} (no objects exported),
ignored if \code{cores == 1}. See \strong{Details} below.}

\item{export_envir}{\code{environment} where to look for the objects defined
in \code{export} when running in parallel and \code{export} is not \code{NULL}. Defaults
to the environment from where \code{\link[=run_trials]{run_trials()}} is called.}
}
\value{
Invisibly returns the default \code{parallel} cluster or \code{NULL}, as
appropriate. This may be used with other functions from the \code{parallel}
package by advanced users, for example to load certain libraries on the
cluster prior to calling \code{\link[=run_trials]{run_trials()}}.
}
\description{
This function setups (or removes) a default cluster for use in all
parallelised functions in \code{adaptr} using the \code{parallel} package. The function
also exports objects that should be available on the cluster and sets the
random number generator appropriately. See \strong{Details} for further info on
how \code{adaptr} handles sequential/parallel computation.
}
\details{
\strong{Using sequential or parallel computing in adaptr}

All parallelised \code{adaptr} functions have a \code{cores} argument that defaults to
\code{NULL}. If a non-\code{NULL} integer \verb{> 0} is provided to the \code{cores} argument in
any of those (except \code{\link[=setup_cluster]{setup_cluster()}}), the package will run calculations
sequentially in the main process if \code{cores = 1}, and otherwise initiate a new
cluster of size \code{cores} that will be removed once the function completes,
regardless of whether or not a default cluster or the global \code{"mc.cores"}
option have been specified.

If \code{cores} is \code{NULL} in any \code{adaptr} function (except \code{\link[=setup_cluster]{setup_cluster()}}), the
package will use a default cluster if one exists or run computations
sequentially if \code{\link[=setup_cluster]{setup_cluster()}} has last been called with \code{cores = 1}.
If \code{\link[=setup_cluster]{setup_cluster()}} has not been called or last called with \code{cores = NULL},
then the package will check if the global \code{"mc.cores"} option has been
specified (using \verb{options(mc.cores = <number of cores>)}). If this option has
been set with a value \verb{> 1}, then a new, temporary cluster of that size is
setup, used, and removed once the function completes. If this option has not
been set or has been set to \code{1}, then computations will be run sequentially
in the main process.

Generally, we recommend using the \code{\link[=setup_cluster]{setup_cluster()}} function as this avoids
the overhead of re-initiating new clusters with every call to one of the
parallelised \code{adaptr} functions. This is especially important when exporting
many or large objects to a \code{parallel} cluster, as this can then be done only
once (with the option to export further objects to the same cluster when
calling \code{\link[=run_trials]{run_trials()}}).

\strong{Type of clusters used and random number generation}

The \code{adaptr} package solely uses parallel socket clusters (using
\code{\link[parallel:makeCluster]{parallel::makePSOCKcluster()}}) and thus does not use forking (as this is not
available on all operating systems and may cause crashes in some situations).
As such, user-defined objects that should be used by the \code{adaptr} functions
when run in parallel need to be exported using either \code{\link[=setup_cluster]{setup_cluster()}} or
\code{\link[=run_trials]{run_trials()}}, if not included in the generated \code{trial_spec} object.

The \code{adaptr} package uses the \code{"L'Ecuyer-CMRG"} kind (see \code{\link[=RNGkind]{RNGkind()}}) for
safe random number generation for all parallelised functions. This is also
the case when running \code{adaptr} functions sequentially with a seed provided,
to ensure that the same results are obtained regardless of whether sequential
or parallel computation is used. All functions restore both the random number
generator kind and the global random seed after use if called with a seed.
}
\examples{

# Setup a cluster using 2 cores
setup_cluster(cores = 2)

# Get existing default cluster (printed here as invisibly returned)
print(setup_cluster())

# Remove existing default cluster
setup_cluster(cores = NULL)

# Specify preference for running computations sequentially
setup_cluster(cores = 1)

# Remove default cluster preference
setup_cluster(cores = NULL)

# Set global option to default to using 2 new clusters each time
# (only used if no default cluster preference is specified)
options(mc.cores = 2)

}
