% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior.R
\name{uniform_log_prior}
\alias{uniform_log_prior}
\alias{log_prior}
\alias{jeffreys_log_prior}
\alias{empirical_gaussian_log_prior}
\title{Priors}
\usage{
uniform_log_prior(parameters)

jeffreys_log_prior(parameters)

empirical_gaussian_log_prior(parameters)
}
\arguments{
\item{parameters}{A data frame containing \code{alpha} and \code{beta} values, 
\code{alpha.range} that specifies sampling density, and \code{log.likelihood}
that contains the unnormalized log likelihood for each
\eqn{(\alpha,\beta)}{(alpha, beta)} pair.}
}
\value{
A vector of log prior values.
}
\description{
Functions designed to be plugged in as \code{log_prior} to \code{\link{make.adeba}}.
}
\references{
A demo explaining how \code{empirical_gaussian_log_prior} was
  implemented can be found in
  \href{https://github.com/backlin/adeba/blob/master/prior-comparison/empirical_gaussian_demo.Rmd}{this Rmarkdown notebook}.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
