clusthr <-function(xy, id=NULL)
{
    if (ncol(xy)!=2)
        stop("xy should have two columns")
    if (is.null(id))
        id<-rep(1, nrow(xy))
    id<-factor(id)
    if (length(id)!=nrow(xy))
        stop("id should have the same length as xy")
    lixy<-split(xy, id)
    res<-list()

    clubase <- function(xy)
    {
        nr <- as.integer(nrow(xy))
        xy <- as.double(t(as.matrix(xy)))
        len2 <- integer(1)
        toto <- .C("longfacclustr", as.double(xy),
                   as.integer(nr), integer(1),
                   PACKAGE = "adehabitat")[[3]]
        return(toto)
    }


    for (i in names(lixy)){
        x<-lixy[[i]]
        ## calcul de la longueur des vecteurs de sortie
        len <- clubase(x)
        ## calcul de l'arbre
        toto <- .C("clusterhrr",
                   as.double(t(as.matrix(x))), as.integer(nrow(x)),
                   integer(len), integer(len), integer(len),
                   as.integer(len), PACKAGE = "adehabitat")
        facso <- toto[[3]]
        nolocso <- toto[[4]]
        cluso <- toto[[5]]
        re <- data.frame(step = facso, clust = cluso, reloc = nolocso)
        res[[i]] <- list(xy = x, results = re)
    }
    class(res) <- "clusthr"
    return(res)
}

print.clusthr <- function(x, ...)
{
    if (!inherits(x, "clusthr"))
        stop("x should be of class \"ichr\"")
    cat("**********************************************\n*\n")
    cat("*  Home range estimation by cluster analysis\n")
    cat("*       (Kenward et al. 2001)\n*\n\n")
    cat("Home range estimated for the individuals:\n")
    print(names(x), quote = FALSE)
    cat("\nEach individual is a component of the list.\n")
    cat("For each individual, the following components are available:\n")
    cat("$xy: the relocations\n")
    cat("$results: a data.frame with the following columns:\n")
    cat("         $step: The step number of the algorithm\n")
    cat("         $clust: The cluster number assigned to some relocations\n")
    cat("         $reloc: The relocation(s) which is (are) assigned\n")
    cat("                 to the cluster \"clust\" at step \"step\"\n\n")

}


plot.clusthr <- function(x, whi = names(x), pch = 21,
                      bgpts = "white", colpts="black", cex=0.7,
                      plotit = TRUE, colpol = "grey",...)
{
    if (!inherits(x, "clusthr"))
        stop("x should be of class \"clusthr\"")
    x <- x[whi]
    class(x) <- "clusthr"
    if (plotit) {
        if (length(whi)>1) {
            opar <- par(mfrow = n2mfrow(length(whi)), mar=c(0,0,2,0))
            on.exit(par(opar))
        }
    }

    ## Pour chaque animal
    restep <- lapply(whi, function(i) {
        ## Un graphe, pour commencer
        if (plotit) {
            plot(x[[i]]$xy, asp=1, ty="n", main=names(x[i]),
                 axes=(length(whi)==1),...)
            box()
            points(x[[i]]$xy, pch= pch, bg = bgpts, col = colpts, cex=cex)
        }
        ## Variables locales
        step <- x[[i]]$results$step
        clust <- x[[i]]$results$clust
        reloc <- x[[i]]$results$reloc

        ## On calcule les niveaux de clusters dispo pour chaque étape:
        liclu <- list()
        liclu[[1]] <- reloc[step==1]
        poltot <- list()
        pc <- data.frame(id=factor(rep(1,3)),x[[i]]$xy[reloc[step==1],])
        class(pc) <- c("area", "data.frame")
        attr(pc,"nlocs") <- 3
        poltot[1] <- list(pc)

        for (j in 2:max(step)) {
            relocj <- reloc[step==j]
            r1 <- relocj[1]
            oussa <- unlist(lapply(1:length(liclu), function(o)
                                   r1%in%liclu[[o]]))
            if (any(oussa)) {
                liclu[[which(oussa)]] <- liclu[[which(oussa)]][-c(which(liclu[[which(oussa)]]%in%relocj))]
            }
            liclu[clust[step==j][1]] <- list(c(unlist(liclu[clust[step==j][1]]), relocj))

            kkk <- lapply(1:length(liclu), function(m) {
                k <- liclu[[m]]
                xy2 <- x[[i]]$xy[k,]
                pol <- xy2[chull(xy2[,1], xy2[,2]),]
                id <- rep(m, nrow(pol))
                pol <- data.frame(id, pol)
                attr(pol,"nlocs") <- nrow(xy2)
                return(pol)
            })
            nlocc <- sum(unlist(lapply(kkk, function(w) attr(w,"nlocs"))))
            pol2 <- do.call("rbind", kkk)
            pol2[,1] <- factor(pol2[,1])
            class(pol2) <- c("area", "data.frame")
            attr(pol2, "nlocs") <- nlocc
            poltot[j] <- list(pol2)
        }
        poltot2 <- list()
        poltot2[[1]] <- poltot[[1]]
        k <- 2
        for (p in 2:length(poltot)) {
            if (!identical(poltot[[p]], poltot[[p-1]])) {
                poltot2[[k]] <- poltot[[p]]
                k <- k+1
            }
        }

        if (plotit) {
            if (!is.na(colpol)) {
                foncol <- get(colpol, pos=".GlobalEnv")
                if (colpol=="grey") {
                    colp <- grey((1:length(poltot2))/(length(poltot2)+1))
                } else {
                    colp <- foncol(length(poltot2))
                }
            } else {
                colp <- NA
            }
            lapply(length(poltot2):1, function(h) {
                ii <- poltot2[[h]]
                lapply(split(ii[,2:3], ii[,1]), function(u)
                       polygon(u, col=colp[h],border="black"))            })
            points(x[[i]]$xy, pch= pch, bg = bgpts, col = colpts, cex=cex)
        }
        return(poltot2)
    })
    invisible(restep)
}





clusthr.area <- function(x, percent = seq(20, 100, by = 5),
                      unin = c("m", "km"), unout = c("ha", "km2", "m2"),
                      plotit=TRUE)
{
    if (!inherits(x, "clusthr"))
        stop("x should be of class \"clusthr\"")
    unin <- match.arg(unin)
    unout <- match.arg(unout)
    if (plotit) {
        opar <- par(mfrow=n2mfrow(length(x)))
        on.exit(par(opar))
    }
    u <- plot(x, plotit=FALSE)
    li <- lapply(1:length(u), function(d) {
        o <- u[[d]]
        nlo <- unlist(lapply(o, function(y) attr(y, "nlocs")))
        ou <- unlist(lapply(o, function(y) {
            lib <- split(y[,2:3], y[,1])
            ji <- sum(unlist(lapply(lib, function(r) {
                class(r) <- c("data.frame")
                names(r) <- c("X","Y")
                row.names(r) <- 1:nrow(r)
                r <- apply(r,2,function(a) a-mean(a))
                area.poly(as(r, "gpc.poly"))
            })))
            return(ji)
        }))
        if (unin == "m") {
            if (unout == "ha")
                ou <- ou/10000
            if (unout == "km2")
                ou <- ou/1e+06
        }
        if (unin == "km") {
            if (unout == "ha")
                ou <- ou * 100
            if (unout == "m2")
                ou <- ou * 1e+06
        }

        nlo <- 100 * nlo/nrow(x[[d]]$xy)
        rere <- data.frame(nlo,ou)
        if (!is.null(percent)) {
            rere <- unlist(lapply(percent, function(e) {
                if (any(nlo<e)) {
                    res <- ou[max(which(nlo<=e))]
                } else {
                    warning(paste(e,
                                  "% contour could not be created.\n More data points are probably needed."))
                    res <- NA
                }
                return(res)
            }))
        }
        return(rere)
    })

    if (plotit) {
        lapply(1:length(x), function(i) {
            if (is.null(percent)) {
                mm <- li[[i]]
            } else {
                mm <- data.frame(percent, li[[i]])
            }
            plot(mm,
                 ty="l", xlab="Home range level",
                 ylab=paste("Home range size (",unout,")", sep=""),
                 main=names(x)[i])
            points(mm, pch=16, cex=0.5)
        })
    }
    if (!is.null(percent)) {
        li <- as.data.frame(do.call("cbind", li))
        names(li) <- names(x)
        row.names(li) <- as.character(percent)
        class(li) <- c("hrsize", "data.frame")
        attr(li, "units") <- unout
    }
    return(li)
}


getverticesclusthr <- function(x, whi=names(x), lev=95)
{
    if (!inherits(x, "clusthr"))
        stop("x should be of class \"clusthr\"")
    x <- x[whi]
    class(x) <- "clusthr"
    uu <- plot(x, plotit=FALSE)
    res2 <- lapply(1:length(uu), function(r) {
        y <- uu[[r]]
        nlo <- unlist(lapply(y, function(z) attr(z, "nlocs")))
        nlo <- 100 * nlo/nrow(x[[r]]$xy)
        if (any(nlo<lev)) {
            res <- max(which(nlo<=lev))
        } else {
            stop(paste(lev,"% contour could not be created.\n More data points are probably needed."))
        }
        return(y[[res]])
    })
    names(res2) <- names(x)
    class(res2) <- "kver"
    return(res2)
}


kver.rast <- function(kv, asc)
{
    if (!inherits(kv,"kver"))
        stop("kv should be of class \"kver\"")
    if (!inherits(asc,"asc"))
        stop("asc should be of class \"asc\"")
    li <- lapply(kv, function(z) {
        ka <- hr.rast(z,asc)
        class(ka) <- "data.frame"
        ka <- as.matrix(ka)
        a <- apply(ka,1,function(a) {
            if (!all(is.na(a))) {
                return(1)
            } else {
                return(NA)
            }})
        as2 <- matrix(a, ncol = ncol(asc))
        as2 <- getascattr(asc,as2)
        return(as2)
    })
    names(li) <- names(kv)
    return(as.kasc(li))
}


kver2shapefile <- function(kv, which=names(kv))
{
    if (!inherits(kv, "kver"))
        stop("x should be of class \"kver\"")
    whi <- which
    kv <- kv[whi]
    nlev <- sum(unlist(lapply(kv, function(x) length(unique(x[,1])))))
    nlo <- 0
    Idatt <- numeric(0)
    Names <- character(0)
    for (i in 1:length(kv)) {
        class(kv[[i]]) <- "data.frame"
        kv[[i]][,1] <- as.numeric(factor(kv[[i]][,1]))+nlo
        lkv <- split(kv[[i]], kv[[i]][,1])
        kv[[i]] <- do.call("rbind", lapply(lkv, function(x) {
            if (abs(sum(unlist(x[1,2:3]-x[nrow(x),2:3])))>1e-16) {
                return(rbind(x, x[1,]))
            }}))
        Idatt <- c(Idatt, (nlo+1):(nlo+length(unique(kv[[i]][,1]))))
        Names <- c(Names, rep(names(kv)[i], length(unique(kv[[i]][,1]))))
        nlo <- nlo+length(unique(kv[[i]][,1]))
    }
    shp <- do.call("rbind", kv)
    names(shp) <- c("Id","X","Y")
    att <- data.frame(Id=Idatt, Names=Names)
    shp.file = convert.to.shapefile(shp, att, "Id", 5)
    return(shp.file)
}

