% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\name{grpnet}
\alias{grpnet}
\title{Solves group elastic net via naive method.}
\usage{
grpnet(
  X,
  glm,
  constraints = NULL,
  groups = NULL,
  alpha = 1,
  penalty = NULL,
  offsets = NULL,
  lmda_path = NULL,
  irls_max_iters = as.integer(10000),
  irls_tol = 1e-07,
  max_iters = as.integer(1e+05),
  tol = 1e-07,
  adev_tol = 0.9,
  ddev_tol = 0,
  newton_tol = 1e-12,
  newton_max_iters = 1000,
  n_threads = 1,
  early_exit = TRUE,
  intercept = TRUE,
  screen_rule = "pivot",
  min_ratio = 0.01,
  lmda_path_size = 100,
  max_screen_size = NULL,
  max_active_size = NULL,
  pivot_subset_ratio = 0.1,
  pivot_subset_min = 1,
  pivot_slack_ratio = 1.25,
  check_state = FALSE,
  progress_bar = TRUE,
  warm_start = NULL
)
}
\arguments{
\item{X}{Feature matrix.}

\item{glm}{GLM object.}

\item{constraints}{Constraints.}

\item{groups}{Groups.}

\item{alpha}{Elastic net parameter.}

\item{penalty}{Penalty factor.}

\item{offsets}{Offsets.}

\item{lmda_path}{The regularization path.}

\item{irls_max_iters}{Maximum number of IRLS iterations.}

\item{irls_tol}{IRLS convergence tolerance.}

\item{max_iters}{Maximum number of coordinate descents.}

\item{tol}{Coordinate descent convergence tolerance.}

\item{adev_tol}{Percent deviance explained tolerance.}

\item{ddev_tol}{Difference in percent deviance explained tolerance.}

\item{newton_tol}{Convergence tolerance for the BCD update.}

\item{newton_max_iters}{Maximum number of iterations for the BCD update.}

\item{n_threads}{Number of threads.}

\item{early_exit}{\code{TRUE} if the function should early exit.}

\item{intercept}{\code{TRUE} to fit with intercept.}

\item{screen_rule}{Screen rule.}

\item{min_ratio}{Ratio between largest and smallest regularization.}

\item{lmda_path_size}{Number of regularizations.}

\item{max_screen_size}{Maximum number of screen groups.}

\item{max_active_size}{Maximum number of active groups.}

\item{pivot_subset_ratio}{Subset ratio of pivot rule.}

\item{pivot_subset_min}{Minimum subset of pivot rule.}

\item{pivot_slack_ratio}{Slack ratio of pivot rule.}

\item{check_state}{Check state.}

\item{progress_bar}{Progress bar.}

\item{warm_start}{Warm start.}
}
\value{
State of the solver.
}
\description{
Solves group elastic net via naive method.
}
\examples{
set.seed(0)
n <- 100
p <- 200
X <- matrix(rnorm(n * p), n, p)
y <- X[,1] * rnorm(1) + rnorm(n)
state <- grpnet(X, glm.gaussian(y))

}
