% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R
\name{gaussian_cov}
\alias{gaussian_cov}
\title{Solves group elastic net via covariance method.}
\usage{
gaussian_cov(
  A,
  v,
  constraints = NULL,
  groups = NULL,
  alpha = 1,
  penalty = NULL,
  lmda_path = NULL,
  max_iters = as.integer(1e+05),
  tol = 1e-07,
  rdev_tol = 0.001,
  newton_tol = 1e-12,
  newton_max_iters = 1000,
  n_threads = 1,
  early_exit = TRUE,
  screen_rule = "pivot",
  min_ratio = 0.01,
  lmda_path_size = 100,
  max_screen_size = NULL,
  max_active_size = NULL,
  pivot_subset_ratio = 0.1,
  pivot_subset_min = 1,
  pivot_slack_ratio = 1.25,
  check_state = FALSE,
  progress_bar = TRUE,
  warm_start = NULL
)
}
\arguments{
\item{A}{Positive semi-definite matrix.}

\item{v}{Linear term.}

\item{constraints}{Constraints.}

\item{groups}{Groups.}

\item{alpha}{Elastic net parameter.}

\item{penalty}{Penalty factor.}

\item{lmda_path}{The regularization path.}

\item{max_iters}{Maximum number of coordinate descents.}

\item{tol}{Coordinate descent convergence tolerance.}

\item{rdev_tol}{Relative percent deviance explained tolerance.}

\item{newton_tol}{Convergence tolerance for the BCD update.}

\item{newton_max_iters}{Maximum number of iterations for the BCD update.}

\item{n_threads}{Number of threads.}

\item{early_exit}{\code{TRUE} if the function should exit early.}

\item{screen_rule}{Screen rule (currently the only value is the default \code{"pivot"}.}

\item{min_ratio}{Ratio between largest and smallest regularization parameter, default is \code{0.01}.}

\item{lmda_path_size}{Number of regularization steps in the path, default is \code{100}.}

\item{max_screen_size}{Maximum number of screen groups, default is \code{NULL} for no maximum.}

\item{max_active_size}{Maximum number of active groups, default is \code{NULL} for no maximum.}

\item{pivot_subset_ratio}{Subset ratio of pivot rule, default is \code{0.1}.}

\item{pivot_subset_min}{Minimum subset of pivot rule, default is \code{1}.}

\item{pivot_slack_ratio}{Slack ratio of pivot rule, default is \code{1.25}.}

\item{check_state}{Check state, default is \code{FALSE}.}

\item{progress_bar}{Progress bar, default is \code{TRUE}.}

\item{warm_start}{Warm start, default is \code{NULL} (no warm start).}
}
\value{
State of the solver.
}
\description{
Solves group elastic net via covariance method.
}
\examples{
set.seed(0)
n <- 100
p <- 200
X <- matrix(rnorm(n * p), n, p)
y <- X[,1] * rnorm(1) + rnorm(n)
A <- t(X) \%*\% X / n
v <- t(X) \%*\% y / n
state <- gaussian_cov(A, v)

}
