% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glintnet.R
\name{glintnet}
\alias{glintnet}
\title{fit a GLM interaction model with group lasso or group elastic-net regularization}
\usage{
glintnet(
  X,
  glm,
  offsets = NULL,
  intr_keys = NULL,
  intr_values,
  levels = NULL,
  n_threads = 1,
  save.X = FALSE,
  ...
)
}
\arguments{
\item{X}{A dense matrix, which can include factors with levels coded as non-negative integers starting at 0.}

\item{glm}{GLM family/response object. This is an expression that
represents the family, the reponse and other arguments such as
weights, if present. The choices are \code{glm.gaussian()},
\code{glm.binomial()}, \code{glm.poisson()},
\code{glm.multinomial()}, \code{glm.cox()}, \code{glm.multinomial()},
and \code{glm.multigaussian()}. This is a required argument, and
there is no default. In the simple example below, we use \code{glm.gaussian(y)}.}

\item{offsets}{Offsets, default is \code{NULL}. If present, this is
a fixed vector or matrix corresponding to the shape of the natural
parameter, and is added to the fit.}

\item{intr_keys}{List of feature indices. This is a list of all features with which interactions can be
formed. Default is \code{1:p} where \code{p} is the number of columns in \code{X}.}

\item{intr_values}{List of integer vectors of feature indices. For each of the \code{m <= p} indices
listed in \code{intr_keys}, there is a vector of indices indicating which columns are candidates for
interaction with that feature. If a vector is \code{NULL}, that means all other features are candidates
for interactions.  The default is a list of length \code{m} where each element is \code{NULL};
that is \code{rep(list(NULL), m}.}

\item{levels}{Number of levels for each of the columns of \code{mat}, with \code{1} representing a
quantitative feature. A factor with \code{K} levels should be represented by the numbers \code{0,1,...,K-1}.}

\item{n_threads}{Number of threads, default \code{1}.}

\item{save.X}{Logical flag, default \code{FALSE}. If \code{TRUE}, the internally constructed X matrix is returned.}

\item{\dots}{Additional named arguments to \code{grpnet}.}
}
\value{
A list of class \code{"glintnet"}, which inherits from class \code{"grpnet"}.
This has a a few additional components such as \code{pairs}, \code{groups} and \code{levels}.
Users typically use methods like \code{predict()}, \code{print()}, \code{plot()} etc to examine the object.
}
\description{
This function is an implementation of the \code{glinternet} model of Lim and Hastie, for fitting interactions between pairs of variables in a model. The method creates \emph{interaction matrices} and enforces hierarchy using the \emph{overlap group lasso}. Once the augmented model matrix is set up,
\code{glintnet} uses \code{grpnet} to fit the overlap group lasso path. It hence inherits all the capabilities of
\code{grpnet}, and in particular can fit interaction models for  all the GLM families.
}
\details{
The input matrix can be composed of quantitative variables or columns representing factors.
The argument \code{levels} indicates which are quantitative, and which are factors.
The later are represented by numbers starting at 0, up to one less than the number of levels (sorry!)
Each of the factors are converted to "one-hot" matrices, and hence a group of columns are created for each of these.
This is done using the matrix utility function \code{matrix.one_hot()}. In addition interaction matrices are created.
For each pair of variables for which an interaction is considered, a matrix is created consisting of the
cross-product of each of the constituent matrices, as described in the "glinternet" reference.
Once this much bigger matrix is established, the model is handed to \code{grpnet} to produce the fit.
}
\examples{
set.seed(0)
n=500
d_cont = 5     # number of continuous features
d_disc = 5     # number of categorical features
Z_cont = matrix(rnorm(n*d_cont), n, d_cont)
levels = sample(2:5,d_disc, replace = TRUE)
Z_disc = matrix(0,n,d_disc)
for(i in seq(d_disc))Z_disc[,i] = sample(0:(levels[i]-1),n,replace=TRUE)
Z = cbind(Z_cont,Z_disc)
levels = c(rep(1,d_cont),levels)

xmat = model.matrix(~Z_cont[,1]*factor(Z_disc[,2]))
nc=ncol(xmat)
beta = rnorm(nc)
y = xmat\%*\%beta+rnorm(n)*1.5

fit <- glintnet(Z, glm.gaussian(y), levels=levels, intr_keys = 1)
print(fit)

}
\references{
Lim, Michael and Hastie, Trevor (2015) \emph{Learning interactions via hierarchical group-lasso regularization}, JCGS
\doi{10.1080/10618600.2014.938812}\cr
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.\cr
Friedman, J., Hastie, T. and Tibshirani, R. (2008)
\emph{Regularization Paths for Generalized Linear Models via Coordinate
Descent (2010), Journal of Statistical Software, Vol. 33(1), 1-22},
\doi{10.18637/jss.v033.i01}.\cr
Simon, N., Friedman, J., Hastie, T. and Tibshirani, R. (2011)
\emph{Regularization Paths for Cox's Proportional
Hazards Model via Coordinate Descent, Journal of Statistical Software, Vol.
39(5), 1-13},
\doi{10.18637/jss.v039.i05}.\cr
Tibshirani,Robert, Bien, J., Friedman, J., Hastie, T.,Simon, N.,Taylor, J. and
Tibshirani, Ryan. (2012) \emph{Strong Rules for Discarding Predictors in
Lasso-type Problems, JRSSB, Vol. 74(2), 245-266},
\url{https://arxiv.org/abs/1011.2234}.\cr
}
\seealso{
\code{cv.glintnet}, \code{predict.glintnet}, \code{plot.glintnet}, \code{print.glintnet}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie
\email{hastie@stanford.edu}
}
