\encoding{UTF-8}
\name{adephylo-package}
\alias{adephylo-package}
\alias{adephylo}
\docType{package}
\title{The adephylo package}

\description{This package is devoted to exploratory analysis of
  phylogenetic comparative data. It re-implements and extends
  phylogenetic procedures from the \code{ade4} package (which are now
  deprecated).\cr

  Comparative data (phylogeny+traits) are handled as
  \linkS4class{phylo4d} objects, a canonical class implemented by the
  \code{phylobase} package. Trees are handled as \code{\link[ape:read.tree]{phylo}}
  objects (from the \code{ape} package) or as \linkS4class{phylo4}
  objects (\code{phylobase}'s extension of \code{phylo} objects).\cr

  Main functionalities of \code{adephylo} are summarized below.\cr

 
   === TOPOLOGICAL INFORMATION ===\cr
   Several functions allow one to retrieve topological information from
   a tree; such information can be used, for instance, as a basis to
   compute distances or proximities between tips.\cr
   
   - \code{\link{listDD}}: lists the direct descendants from each node
   of a tree.\cr

   - \code{\link{listTips}}:  lists the tips descending from each node
   of a tree.\cr

   - \code{\link{.tipToRoot}}: finds the set of nodes between a tip and the root of
   a tree.\cr

   - \code{\link{sp.tips}}: finds the shortest path between tips of a
   tree.\cr

   - \code{\link{treePart}}: defines partitions of tips reflecting the
  topology of a tree. This function can output non-independent dummy
  vectors, or alternatively an orthonormal basis used by the orthogram procedure.\cr

  

   === PHYLOGENETIC PROXIMITIES/DISTANCES ===\cr
   Several phylogenetic proximities and distances are
   implemented. Auxiliary function easing the computation of other
   distances/proximities are also provided:\cr
   
   - \code{\link{distRoot}}: computes different distances of a set of tips to the
  root.\cr
 
   - \code{\link{distTips}}: computes different pairwise distances in a set of tips.\cr

   - \code{\link{proxTips}}: computes different proximities between a
   set of tips.\cr


   === MEASURES/TESTS OF PHYLOGENETIC AUTOCORRELATION  ===\cr
   Several procedures allow one to measure, and/or test phylogenetic
   signal in biological traits:\cr
   
   - \code{\link{abouheif.moran}}: performs Abouheif's test, designed to
   detect phylogenetic autocorrelation in a quantitative trait. This
   implementation is not based on original heuristic procedure, but on
   the exact formulation proposed by Pavoine et al. (2008), showing that
   the test is in fact a Moran's index test. This implementation further
   extends the procedure by allowing any measure of phylogenetic
   proximity (5 are proposed).\cr

   - \code{\link{orthogram}}: performs the orthonormal decomposition of
   variance of a quantitative variable on an orthonormal basis as in
   Ollier et al. (2005). It also returns the results of five non
   parametric tests associated to the variance decomposition.\cr

   - \code{\link{moran.idx}}: computes Moran's index of autocorrelation
   given a variable and a matrix of proximities among observations (no
   test).\cr
   

   === MODELLING/INVESTIGATION OF PHYLOGENETIC SIGNAL ===\cr
   Rather than testing or measuring phylogenetic autocorrelation, these
   procedures can be used for further investigation of phylogenetic
   signal. Some, like \code{\link{me.phylo}}, can be used to remove
   phylogenetic autocorrelation. Others can be used to understand the
   nature of this autocorrelation (i.e., to ascertain which traits and
   tips are concerned by phylogenetic non-independence).\cr
   
   - \code{\link{me.phylo}}/\code{\link{orthobasis.phylo}}: these
   synonymous functions compute Moran's eigenvectors (ME) associated to
   a tree. These vectors model different observable phylogenetic
   signals. They can be used as covariables to remove phylogenetic
   autocorrelation from data.\cr

   - \code{\link{orthogram}}: the orthogram mentionned above also
   provides a description of how biological variability is structured
   on a phylogeny.\cr

   - \code{\link{ppca}}: performs a phylogenetic Principal
   Component Analysis (pPCA, Jombart et al. 2010). This multivariate
   method investigates phylogenetic patterns in a set of quantitative
   traits.\cr

   
   === GRAPHICS ===\cr
   Some plotting functions are proposed, most of them being devoted to
   representing phylogeny and a quantitative information at the same
   time.\cr
   
   - \code{\link{table.phylo4d}}: fairly customisable way of
   representing traits onto the tips of a phylogeny. Several traits can
   be plotted in a single graphic.\cr

   - \code{\link{bullseye}}: an alternative to
     \code{\link{table.phylo4d}} based on fan-like representation, better
     for large trees.\cr

   - \code{\link{scatter.ppca}}, \code{\link{screeplot.ppca}},
   \code{\link{plot.ppca}}: several plots associated to a phylogenetic
   principal component analysis (see \code{\link{ppca}}).\cr
   
   
   === DATASETS ===\cr
   Several datasets are also proposed. Some of these datasets 
   replace former version from \code{ade4}, which are now deprecated.
   Here is a list of available datasets: \code{\link{carni19}},
   \code{\link{carni70}}, \code{\link{lizards}}, \code{\link{maples}},
   \code{\link{mjrochet}}, \code{\link{palm}}, \code{\link{procella}},
   \code{\link{tithonia}}, and \code{\link{ungulates}}.\cr

   
   To cite adephylo, please use the reference given by
   \code{citation("adephylo")}.
 }
\details{
  \tabular{ll}{
    Package: \tab adephylo\cr
    Type: \tab Package\cr
    Version: \tab 1.1-4\cr
    Date: \tab 2013-05-22 \cr
    License: \tab GPL (>=2)
  }  
}
\author{
  Thibaut Jombart <tjombart@imperial.ac.uk>\cr
  with contributions Stéphane Dray <dray@biomserv.univ-lyon1.fr>. \cr
  Parts of former code from \code{ade4} by Daniel Chessel and Sébastien
  Ollier.
}
\keyword{manip}
\keyword{multivariate}
\seealso{The \code{ade4} package for multivariate analysis.}
