% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stimodels.R
\name{stimodels}
\alias{stimodels}
\alias{quicksti}
\alias{quicksti}
\title{Space-time interaction in ANOVA without replication}
\usage{
stimodels(Y, S, Ti, model = "5", nperm = 999, nS = -1, nT = -1,
  Sfixed = TRUE, Tfixed = TRUE, COD.S = NULL, COD.T = NULL,
  print.res = TRUE)

quicksti(Y, S, Ti, nperm = 999, alpha = 0.05, COD.S = NULL,
  COD.T = NULL, print.res = TRUE)
}
\arguments{
\item{Y}{Site-by-species response data table. Assumes row blocks
corresponding to times, i.e. within each block all sites are provided 
(in the same order).}

\item{S}{Number of spatial points (when they are aligned on a transect or a
time series and equispaced) or a matrix of spatial coordinates (when the
sites are on a two-dimensional surface or on a line but very irregularly
spaced).}

\item{Ti}{Number of time campaigns (when equispaced) or a matrix (a
vector) of temporal coordinates (when the time campaigns are very 
irregularly spaced).}

\item{model}{Linear space-time model to be used (can be either "2", "3a",
"3b", "4", "5", "6a", "6b", or "7").}

\item{nperm}{Number of permutations in the significance tests.}

\item{nS}{Number of space dbMEMs to use (by default, -1, all dbMEMs with
positive autocorrelation are used).}

\item{nT}{Number of time dbMEMs to use (by default, -1, all dbMEMs with
positive autocorrelation are used).}

\item{Sfixed}{Logical: is factor Space fixed, or not (if FALSE, it is
considered a random factor).}

\item{Tfixed}{Logical: is factor Time fixed, or not (if FALSE, it is
considered a random factor).}

\item{COD.S}{Spatial coding functions to be used instead of dbMEM. The
number of columns must be lower than \code{S} and the number of rows equal
to the number of rows in \code{Y}.}

\item{COD.T}{Temporal coding functions to be used instead of dbMEM. The
number of columns must be lower than \code{Ti} and the number of rows equal
to the number of rows in \code{Y}.}

\item{print.res}{If TRUE displays the results and additional information
onscreen (recommended).}

\item{alpha}{In \code{quicksti}, confidence level for the interaction test. 
Depending on the decision for the interaction test, the main factors are 
tested differently.}
}
\value{
\item{testS}{ An object with the result of the space effect test, including
the mean squares for the F numerator (\code{MS.num}), the mean squares for
the F denominator (\code{MS.den}), the proportion of explained variance
(\code{R2}), the adjusted proportion of explained variance (\code{R2.adj}),
the F statistics (\code{F}) and its p-value computed from a permutation test
(\code{Prob}). } \item{testT}{ An object with the result of the time effect
test, like \code{testS}.} \item{teststi}{ An object with the result of the
space-time interaction test, like \code{testS}.}
}
\description{
Function \code{stimodels} performs two-way ANOVA to test space-time
interaction without replicates using one among a set of possible models.
Function \code{quicksti} allows performing space-time ANOVA in a simplified
way. In many models, degrees of freedom are saved by coding space and/or
time parsimoniously using distance-based Moran Eigenvector Maps (dbMEM).
}
\details{
In \code{stimodels} tests for space-time interaction and space or time main
effects are conducted using one of the different models. With Models 2, 6a
and 6b the interaction test is not available.

Model 2 - Space and Time are coded using Helmert contrasts for the main
effects. No interaction is tested. Model 3a - Space is coded using dbMEM
variables whereas Time is coded using Helmert contrasts. Model 3b - Space is
coded using Helmert contrasts whereas Time is coded using dbMEM variables.
Model 4 - Both Space and Time are coded using dbMEM variables for all tests.
Model 5 - Space and Time are coded using Helmert contrasts for the main
factor effects, but they are coded using dbMEM variables for the interaction
term. Model 6a - Nested model. Testing for the existence of spatial
structure (common or separate) using dbMEM variables to code for Space.
Model 6b - Nested model. Testing for the existence of temporal structure
(common or separate) using dbMEM variables to code for Time. Model 7 -
Space and Time are coded using dbMEM variables for the main factor effects,
but they are coded using Helmert contrasts for the interaction term (not
recommended).

When using \code{quicksti}, space-time interaction is first tested using
Model 5. Depending on the outcome of this test, the main factors are tested
using different strategies. If the interaction is not significant then the
test of main factors is also done following Model 5. If the interaction is
significant, then a nested model (6a) is used to know whether separate
spatial structures exist and another (6b) to know whether separate temporal
structures exist. In \code{quicksti} function space and time are always
considered fixed factors (F ratios are constructed using residual MS in the
denominator).

For the interaction the permutations are unrestricted, whereas for the main
factors the permutations are restricted within time blocks (for the test of
factor Space) or space blocks (for the test of factor Time). By default, the
function computes dbMEM for space and time coding, but other space and/or
time descriptors can be provided by the user, through \code{COD.S} and
\code{COD.T}.
}
\examples{

data(trichoptera)

# log-transform species data (excluding site and time colums)
trich.log <- log1p(trichoptera[,-c(1,2)]) 


# Run space-time interaction test using model "5"
stimodels(trich.log, S=22, Ti=10, nperm=99, model="5")

# Run space-time analysis with tests for main effects after testing 
# interaction (which is significant)
quicksti(trich.log, S=22, Ti=10, nperm=99)

# Run space-time analysis for time blocks number 6 and 7. 
# Interaction is then not significant and tests of main effects are done 
# following model 5
quicksti(trich.log[111:154,], S=22, Ti=2, nperm=99)

}
\references{
Borcard, D. and P. Legendre. 2002. All-scale spatial analysis of
ecological data by means of principal coordinates of neighbour matrices.
Ecological Modelling 153: 51-68.

Dray, S., P. Legendre and P. R. Peres-Neto. 2006. Spatial modelling: a
comprehensive framework for principal coordinate analysis of neighbour
matrices (PCNM). Ecological Modelling 196: 483-493.

Legendre, P., M. De Caceres and D. Borcard. 2010. Community surveys through
space and time to assess environmental changes: testing space-time
interaction in the absence of replication. Ecology 91: 262-272.
}
\seealso{
\code{\link{trichoptera}}
}
\author{
Pierre Legendre \email{pierre.legendre@umontreal.ca}, Miquel De Caceres and Daniel Borcard
}
\keyword{multivariate}
\keyword{spatial}
