% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forward.sel.R
\name{forward.sel}
\alias{forward.sel}
\title{Forward selection with multivariate Y using permutation under reducel model}
\usage{
forward.sel(Y, X, K = nrow(X) - 1, R2thresh = 0.99, adjR2thresh = 0.99,
  nperm = 999, R2more = 0.001, alpha = 0.05, Xscale = TRUE,
  Ycenter = TRUE, Yscale = FALSE, verbose = TRUE)
}
\arguments{
\item{Y}{Response data matrix with n rows and m columns containing 
quantitative variables}

\item{X}{Explanatory data matrix with n rows and p columns containing 
quantitative variables}

\item{K}{Maximum number of variables to be selected. The default is one minus
the number of rows}

\item{R2thresh}{Stop the forward selection procedure if the R-square of the 
model exceeds the stated value. This parameter can vary from 0.001 to 1}

\item{adjR2thresh}{Stop the forward selection procedure if the adjusted 
R-square of the model exceeds the stated value. This parameter can take any
value (positive or negative) smaller than 1}

\item{nperm}{The number of permutation to be used.The default setting is 999 
permutation.}

\item{R2more}{Stop the forward selection procedure if the difference in model
R-square with the previous step is lower than R2more. The default setting 
is 0.001}

\item{alpha}{Significance level. Stop the forward selection procedure if the 
p-value of a variable is higher than alpha. The default is 0.05 is TRUE}

\item{Xscale}{Standardize the variables in table X to variance 1. The default
setting is TRUE}

\item{Ycenter}{Center the variables in table Y. The default setting is TRUE}

\item{Yscale}{Standardize the variables in table Y to variance 1. The default
setting is FALSE.}

\item{verbose}{If 'TRUE' more diagnostics are printed. The default setting is
TRUE}
}
\value{
A dataframe with: \item{ variables }{ The names of the variables } 
  \item{ order }{ The order of the selection of the variables } \item{ R2 }{ 
  The R2 of the variable selected } \item{ R2Cum }{ The cumulative R2 of the 
  variables selected } \item{ AdjR2Cum }{ The cumulative adjusted R2 of the 
  variables selected } \item{ F }{ The F statistic } \item{ pval }{ The 
  P-value statistic }
}
\description{
Performs a forward selection by permutation of residuals under reduced model.
Y can be multivariate.
}
\details{
The forward selection will stop when either K, R2tresh, adjR2tresh, alpha and
R2more has its parameter reached.
}
\note{
Not yet implemented for CCA (weighted regression) and with covariables.
}
\examples{

x <- matrix(rnorm(30),10,3)
y <- matrix(rnorm(50),10,5)
    
forward.sel(y,x,nperm=99, alpha = 0.5)
 
}
\references{
Canoco manual p.49
}
\author{
Stephane Dray \email{stephane.dray@univ-lyon1.fr}
}
\keyword{multivariate}
