#' Mastigouche Lake network data set
#' 
#' A list containing the XY coordinates of the lakes and a site-by-edge matrix
#' describing how 42 lakes influence each other. The influence is defined by 66
#' edges.
#' 
#' @docType data
#' @references
#' 
#' Magnan, P., Rodriguez, M.A., Legendre, P., Lacasse, S. (1994) Dietary
#' variation in a freshwater fish species: relative contribution of biotic
#' interactions, abiotic factors, and spatial structure. \emph{Canadian Journal
#' of Fisheries and Aquatic Sciences} 51, 2856-2865. Blanchet F.G., P. Legendre,
#' and Borcard D. (2008) Modelling directional spatial processes in ecological
#' data. \emph{Ecological Modelling}, 215, 325-336.
#' 
#' @keywords datasets
#' @name mastigouche
#' @usage data(mastigouche)
#' @format A list that includes the centred coordinates of 42 lakes in the
#'   Mastigouche reserve and a site-by-edge matrix describing how the 42 lakes
#'   are influenced among each other. The influence is defined by 66 edges.
NULL