"denoiseheteroprop" <-
function(x,f,pred,neigh,int,clo,keep,rule="median",gamvec){

#denoises input using prediction scheme specified by other arguments
#artificial level thresholding, values generated by ebayesthresh using normalized detail coefficients

#with info about variances:gamvec is a vector of noise sd (!SD, not var!) proportionality constants
# (in order of observing x)

newcoeff<-NULL
NEWcoeff<-NULL
newcoeff1<-NULL
newcoeffuniv<-NULL
ndetlist<-list()
tclist<-list()
TClist<-list()
zdetlist<-list()
tclist1<-list()
tcuniv<-list()
nonortclist<-list()
nonornewcoeff<-NULL
norcoeff<-NULL
#q<-list()
sigmamat<-matrix(0,length(x),length(x))

temp<-transmatdual(x,f,pred,neigh,int,clo,keep)
w<-temp$Wnew
out<-temp$out

#work out sd for normalising...

for (i in 1:length(x)){
sigmamat[i,i]<-gamvec[i]^2	     #sigma is a diag matrix with sigmai^2=gamvec[i] on the leading diag
}
varmat<-w%*%(sigmamat)	     
varmat<-(varmat)%*%t(w)	     #varmat is the var-covariance matrix of the lifted coeff's
indsd<-sqrt(diag(varmat))    #this will contain the sd of the scaling coefficients as well

norcoeff<-out$coeff/indsd

nonorcoeff<-out$coeff

lr<-out$lengthsremove    #vector deciding how to divide up coefficients into artificial levels
rem<-out$removelist      #used to convert output to original lr,rem)

al<-artlev1(lr,rem)      #the list of indices of removelist separated into levels

levno<-length(al)
for (i in 1:levno){
ndetlist[[i]]<-norcoeff[al[[i]]]
	}

sd<-mad(ndetlist[[1]])    #uses the first (largest) level to estimate noise standard deviation
sd1<-mad(ndetlist[[1]],center=0)
sd2<-mad(norcoeff[rem]) #uses all the normalised details to estimate the noise std dev

for (i in 1:levno){

tclist[[i]]<-ebayesthresh(ndetlist[[i]],prior="cauchy",a=NA,sdev=sd,threshrule=rule)
zdetlist[[i]]<-(ndetlist[[i]]/sd)

	}

#^^^creates list of thresholded coefficients (in levels) using HARD threshold scheme and post. median values 

for (i in 1:levno){
newcoeff[al[[i]]]<-tclist[[i]]*indsd[al[[i]]]
}

newcoeff[out$pointsin]<-out$coeff[out$pointsin]

#^^^^^^^^^new unnormalised coeff vector (details and scaling coeffs)


fhat<-invtnp(x,newcoeff,out$lengths,lr,out$pointsin,rem,out$neighbrs,out$schemehist,out$interhist,length(x)-keep,int,neigh,clo,pred)

return(list(out=out,w=w,indsd=indsd,al=al,sd=sd,fhat=fhat))
}
