% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_var_merged_exist_flag}
\alias{derive_var_merged_exist_flag}
\title{Merge an Existence Flag}
\usage{
derive_var_merged_exist_flag(
  dataset,
  dataset_add,
  by_vars,
  new_var,
  condition,
  true_value = "Y",
  false_value = NA_character_,
  missing_value = NA_character_,
  filter_add = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{by_vars}{Grouping variables

\emph{Permitted Values}: list of variables}

\item{new_var}{New variable

The specified variable is added to the input dataset.}

\item{condition}{Condition

The condition is evaluated at the additional dataset (\code{dataset_add}). For
all by groups where it evaluates as \code{TRUE} at least once the new variable
is set to the true value (\code{true_value}). For all by groups where it
evaluates as \code{FALSE} or \code{NA} for all observations the new variable is set
to the false value (\code{false_value}). The new variable is set to the missing
value (\code{missing_value}) for by groups not present in the additional
dataset.}

\item{true_value}{True value

\emph{Default}: \code{"Y"}}

\item{false_value}{False value

\emph{Default}: \code{NA_character_}}

\item{missing_value}{Values used for missing information

The new variable is set to the specified value for all by groups without
observations in the additional dataset.

\emph{Default}: \code{NA_character_}

\emph{Permitted Value}: A character scalar}

\item{filter_add}{Filter for additional data

Only observations fulfilling the specified condition are taken into account
for flagging. If the argument is not specified, all observations are
considered.

\emph{Permitted Values}: a condition}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variable specified for \code{new_var} derived
from the additional dataset (\code{dataset_add}).
}
\description{
Adds a flag variable to the input dataset which indicates if there exists at
least one observation in another dataset fulfilling a certain condition.
}
\details{
\enumerate{
\item The additional dataset is restricted to the observations matching the
\code{filter_add} condition.
\item The new variable is added to the input dataset and set to the true value
(\code{true_value}) if for the by group at least one observation exists in the
(restricted) additional dataset where the condition evaluates to \code{TRUE}. It
is set to the false value (\code{false_value}) if for the by group at least one
observation exists and for all observations the condition evaluates to
\code{FALSE} or \code{NA}. Otherwise, it is set to the missing value
(\code{missing_value}).
}
}
\examples{

library(admiral.test)
library(dplyr, warn.conflicts = FALSE)
data("admiral_dm")
data("admiral_ae")
derive_var_merged_exist_flag(
  admiral_dm,
  dataset_add = admiral_ae,
  by_vars = exprs(STUDYID, USUBJID),
  new_var = AERELFL,
  condition = AEREL == "PROBABLE"
) \%>\%
  select(STUDYID, USUBJID, AGE, AGEU, AERELFL)

data("admiral_vs")
derive_var_merged_exist_flag(
  admiral_dm,
  dataset_add = admiral_vs,
  by_vars = exprs(STUDYID, USUBJID),
  filter_add = VSTESTCD == "WEIGHT" & VSBLFL == "Y",
  new_var = WTBLHIFL,
  condition = VSSTRESN > 90,
  false_value = "N",
  missing_value = "M"
) \%>\%
  select(STUDYID, USUBJID, AGE, AGEU, WTBLHIFL)
}
\seealso{
General Derivation Functions for all ADaMs that returns variable appended to dataset:
\code{\link{derive_var_extreme_flag}()},
\code{\link{derive_var_joined_exist_flag}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_merged_character}()},
\code{\link{derive_var_merged_summary}()},
\code{\link{derive_var_obs_number}()},
\code{\link{derive_var_relative_flag}()},
\code{\link{derive_vars_joined}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{derive_vars_merged_lookup}()},
\code{\link{derive_vars_merged}()},
\code{\link{derive_vars_transposed}()},
\code{\link{get_summary_records}()}
}
\concept{der_gen}
\keyword{der_gen}
