% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_extreme_date.R
\name{date_source}
\alias{date_source}
\title{Create a \code{date_source} object}
\usage{
date_source(
  dataset_name,
  filter = NULL,
  date,
  date_imputation = NULL,
  time_imputation = NULL,
  preserve = FALSE,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the date.}

\item{filter}{An unquoted condition for filtering \code{dataset}.}

\item{date}{A variable providing a date. A date, a datetime, or a character
variable containing ISO 8601 dates can be specified. An unquoted symbol is
expected.}

\item{date_imputation}{A string defining the date imputation for \code{date}.
See \code{date_imputation} parameter of \code{impute_dtc()} for valid values.}

\item{time_imputation}{A string defining the time imputation for \code{date}.
See \code{time_imputation} parameter of \code{impute_dtc()} for valid values.}

\item{preserve}{Should day be preserved if month is imputed for \code{date}.
See \code{preserve} parameter of \code{impute_dtc()} for details.}

\item{traceability_vars}{A named list returned by \code{vars()} defining the
traceability variables, e.g. \code{vars(LALVDOM = "AE", LALVSEQ = AESEQ, LALVVAR = "AESTDTC")}. The values must be a symbol, a character string, a numeric,
or \code{NA}.}
}
\value{
An object of class \code{date_source}.
}
\description{
Create a \code{date_source} object as input for \code{derive_var_extreme_dt()} and
\code{derive_var_extreme_dtm()}.
}
\seealso{
\code{\link[=derive_var_extreme_dtm]{derive_var_extreme_dtm()}}, \code{\link[=derive_var_extreme_dt]{derive_var_extreme_dt()}}
}
\author{
Stefan Bundfuss
}
\keyword{source_specifications}
