% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dtm_to_dt.R
\name{derive_vars_dtm_to_dt}
\alias{derive_vars_dtm_to_dt}
\title{Derive Date Variables from Datetime Variables}
\usage{
derive_vars_dtm_to_dt(dataset, source_vars)
}
\arguments{
\item{dataset}{Input dataset}

\item{source_vars}{A list of datetime variables created using \code{vars()} from
which dates are to be extracted}
}
\value{
A data frame containing the input dataset with the corresponding date (\code{--DT})
variable(s) of all datetime variables (\code{--DTM}) specified in \code{source_vars.}
}
\description{
This function creates date(s) as output from datetime variable(s)
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

adcm <- tibble::tribble(
  ~USUBJID, ~TRTSDTM,              ~ASTDTM,               ~AENDTM,
  "PAT01",  "2012-02-25 23:00:00", "2012-02-28 19:00:00", "2012-02-25 23:00:00",
  "PAT01",  NA,                    "2012-02-28 19:00:00", NA,
  "PAT01",  "2017-02-25 23:00:00", "2013-02-25 19:00:00", "2014-02-25 19:00:00",
  "PAT01",  "2017-02-25 16:00:00", "2017-02-25 14:00:00", "2017-03-25 23:00:00",
  "PAT01",  "2017-02-25 16:00:00", "2017-02-25 14:00:00", "2017-04-29 14:00:00",
) \%>\%
  mutate(
    TRTSDTM = as_datetime(TRTSDTM),
    ASTDTM = as_datetime(ASTDTM),
    AENDTM = as_datetime(AENDTM)
  )

adcm \%>\%
  derive_vars_dtm_to_dt(vars(TRTSDTM, ASTDTM, AENDTM)) \%>\%
  select(USUBJID, starts_with("TRT"), starts_with("AST"), starts_with("AEN"))
}
\author{
Teckla Akinyi
}
\keyword{adam}
\keyword{timing}
