% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_tte.R
\name{filter_date_sources}
\alias{filter_date_sources}
\title{Select the First or Last Date from Several Sources}
\usage{
filter_date_sources(
  sources,
  source_datasets,
  by_vars,
  create_datetime = FALSE,
  subject_keys,
  mode
)
}
\arguments{
\item{sources}{Sources

A list of \code{tte_source()} objects is expected.}

\item{source_datasets}{Source datasets

A named list of datasets is expected. The \code{dataset_name} field of
\code{tte_source()} refers to the dataset provided in the list.}

\item{by_vars}{By variables

If the parameter is specified, for each by group the observations are
selected separately.}

\item{create_datetime}{Create datetime variable?

If set to \code{TRUE}, variables \code{ADTM} is created. Otherwise, variables \code{ADT}
is created.}

\item{subject_keys}{Variables to uniquely identify a subject

A list of symbols created using \code{vars()} is expected.}

\item{mode}{Selection mode (first or last)

If \code{"first"} is specified, for each subject the first observation with
respect to the date is included in the output dataset. If \code{"last"} is
specified, the last observation is included in the output dataset.

Permitted Values:  \code{"first"}, \code{"last"}}
}
\value{
A dataset with one observation per subject as described in the
"Details" section.
}
\description{
Select for each subject the first or last observation with respect to a date
from a list of sources.
}
\details{
The following steps are performed to create the output dataset:

\enumerate{ \item For each source dataset the observations as specified by
the \code{filter} element are selected. Then for each patient the first or last
observation (with respect to \code{date}) is selected.

\item The \code{ADT} variable is set to the variable specified by the
\code{date} element. If the date variable is a datetime variable, only
the datepart is copied. If the source variable is a character variable, it
is converted to a date. If the date is incomplete, it is imputed as
the first possible date.

\item The \code{CNSR} is added and set to the value of the \code{censor}
element.

\item The selected observations of all source datasets are combined into a
single dataset.

\item For each patient the first or last observation (with respect to the
\code{ADT} variable) from the single dataset is selected. }
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(lubridate)

adsl <- tibble::tribble(
  ~USUBJID, ~TRTSDT,           ~EOSDT,
  "01",     ymd("2020-12-06"), ymd("2021-03-06"),
  "02",     ymd("2021-01-16"), ymd("2021-02-03")
) \%>\%
  mutate(STUDYID = "AB42")

ae <- tibble::tribble(
  ~USUBJID, ~AESTDTC,           ~AESEQ, ~AEDECOD,
  "01",     "2021-01-03T10:56", 1,      "Flu",
  "01",     "2021-03-04",       2,      "Cough",
  "01",     "2021",             3,      "Flu"
) \%>\%
  mutate(STUDYID = "AB42")

ttae <- event_source(
  dataset_name = "ae",
  date = AESTDTC,
  set_values_to = vars(
    EVNTDESC = "AE",
    SRCDOM = "AE",
    SRCVAR = "AESTDTC",
    SRCSEQ = AESEQ
  )
)

filter_date_sources(
  sources = list(ttae),
  source_datasets = list(adsl = adsl, ae = ae),
  by_vars = vars(AEDECOD),
  create_datetime = FALSE,
  subject_keys = vars(STUDYID, USUBJID),
  mode = "first"
)
}
\author{
Stefan Bundfuss
}
\keyword{dev_utility}
