% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_character_scalar}
\alias{assert_character_scalar}
\title{Is an Argument a Character Scalar (String)?}
\usage{
assert_character_scalar(
  arg,
  values = NULL,
  case_sensitive = TRUE,
  optional = FALSE
)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{values}{A \code{character} vector of valid values for \code{arg}}

\item{case_sensitive}{Should the argument be handled case-sensitive?
If set to \code{FALSE}, the argument is converted to lower case for checking the
permitted values and returning the argument.}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a character vector or if \code{arg}
is a character vector but of length > 1 or if its value is not one of the \code{values}
specified. Otherwise, the input is returned invisibly.
}
\description{
Checks if an argument is a character scalar and (optionally) whether it matches
one of the provided \code{values}.
}
\examples{
example_fun <- function(msg_type) {
  assert_character_scalar(msg_type, values = c("warning", "error"))
}

example_fun("warning")

try(example_fun("message"))

try(example_fun(TRUE))

# handling parameters case-insensitive
example_fun2 <- function(msg_type) {
  msg_type <- assert_character_scalar(
    msg_type,
    values = c("warning", "error"),
    case_sensitive = FALSE
  )
  if (msg_type == "warning") {
    print("A warning was requested.")
  }
}

example_fun2("Warning")
}
\author{
Thomas Neitmann
}
\keyword{assertion}
