% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_list_element}
\alias{assert_list_element}
\title{Is an Element of a List of Lists/Classes Fulfilling a Condition?}
\usage{
assert_list_element(list, element, condition, message_text, ...)
}
\arguments{
\item{list}{A list to be checked

A list of named lists or classes is expected.}

\item{element}{The name of an element of the lists/classes

A character scalar is expected.}

\item{condition}{Condition to be fulfilled

The condition is evaluated for each element of the list. The element of the
lists/classes can be referred to by its name, e.g., \code{censor == 0} to check
the \code{censor} field of a class.}

\item{message_text}{Text to be displayed in the message

The text should describe the condition to be fulfilled, e.g., "For events
the censor values must be zero.".}

\item{...}{Objects required to evaluate the condition

If the condition contains objects apart from the element, they have to be
passed to the function. See the second example below.}
}
\value{
An error if the condition is not meet. The input otherwise.
}
\description{
Checks if the elements of a list of named lists/classes fulfill a certain
condition. If not, an error is issued and all elements of the list not
fulfilling the condition are listed.
}
\examples{
death <- event_source(
  dataset_name = "adsl",
  filter = DTHFL == "Y",
  date = DTHDT,
  set_values_to = vars(
    EVNTDESC = "DEATH",
    SRCDOM = "ADSL",
    SRCVAR = "DTHDT"
  )
)

lstalv <- censor_source(
  dataset_name = "adsl",
  date = LSTALVDT,
  set_values_to = vars(
    EVNTDESC = "LAST KNOWN ALIVE DATE",
    SRCDOM = "ADSL",
    SRCVAR = "LSTALVDT"
  )
)
events <- list(death, lstalv)
try(assert_list_element(
  list = events,
  element = "censor",
  condition = censor == 0,
  message_text = "For events the censor values must be zero."
))

valid_datasets <- c("adrs", "adae")
try(assert_list_element(
  list = events,
  element = "dataset_name",
  condition = dataset_name \%in\% valid_datasets,
  valid_datasets = valid_datasets,
  message_text = paste0(
    "The dataset name must be one of the following:\n",
    paste(valid_datasets, collapse = ", ")
  )
))
}
\author{
Stefan Bundfuss
}
\keyword{assertion}
