% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_order_vars}
\alias{assert_order_vars}
\title{Is an Argument a List of Order Variables?}
\usage{
assert_order_vars(arg, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a list of variables or \code{desc()}
calls created using \code{vars()} and returns the input invisibly otherwise.
}
\description{
Checks if an argument is a valid list of order variables created using \code{vars()}
}
\examples{
example_fun <- function(by_vars) {
  assert_order_vars(by_vars)
}

example_fun(vars(USUBJID, PARAMCD, desc(AVISITN)))

try(example_fun(rlang::exprs(USUBJID, PARAMCD)))

try(example_fun(c("USUBJID", "PARAMCD", "VISIT")))

try(example_fun(vars(USUBJID, toupper(PARAMCD), -AVAL)))
}
\author{
Stefan Bundfuss
}
\keyword{assertion}
