% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_last_dose.R
\name{derive_last_dose}
\alias{derive_last_dose}
\title{Derive Last Dose Date(-time)}
\usage{
derive_last_dose(
  dataset,
  dataset_ex,
  filter_ex = NULL,
  by_vars = vars(STUDYID, USUBJID),
  dose_start,
  dose_end,
  analysis_date,
  dataset_seq_var,
  new_var,
  output_datetime = TRUE,
  check_dates_only = FALSE,
  traceability_vars = NULL
)
}
\arguments{
\item{dataset}{Input dataset.}

\item{dataset_ex}{Input EX dataset.}

\item{filter_ex}{Filtering condition applied to EX dataset.
For example, it can be used to filter for valid dose.
Defaults to NULL.}

\item{by_vars}{Variables to join by (created by \code{dplyr::vars}).}

\item{dose_start}{The dose start date variable.}

\item{dose_end}{The dose end date variable.}

\item{analysis_date}{The analysis date variable.}

\item{dataset_seq_var}{The sequence variable
(this together with \code{by_vars} creates the keys of \code{dataset}).}

\item{new_var}{The output variable.}

\item{output_datetime}{Logical. Should only date or date-time variable be returned?
Defaults to \code{TRUE} (i.e. date-time variable).}

\item{check_dates_only}{Logical.
An assumption that start and end dates of treatment match is checked.
By default (\code{FALSE}), the date as well as the time component is checked.
If set to \code{TRUE}, then only the date component of those variables is checked.}

\item{traceability_vars}{A named list returned by \code{\link[=vars]{vars()}} listing the traceability variables,
e.g. \code{vars(LDOSEDOM = "EX", LDOSESEQ = EXSEQ)}.
The left-hand side (names of the list elements) gives the names of the traceability variables
in the returned dataset.
The right-hand side (values of the list elements) gives the values of the traceability variables
in the returned dataset.
These can be either strings or symbols referring to existing variables.}
}
\value{
Input dataset with additional column \code{new_var}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\emph{Deprecated}, please use \code{derive_var_last_dose_date()} instead.
}
\details{
All date (date-time) variables can be characters in standard ISO format or
of date / date-time class.
For ISO format, see \code{\link{impute_dtc}} - parameter \code{dtc} for further details.
Date-time imputations are done as follows:
\itemize{
\item \code{dose_end}: no date imputation, time imputation to \code{00:00:00} if time is missing.
\item \code{analysis_date}: no date imputation, time imputation to \code{23:59:59} if time is missing.
}

The last dose date is derived as follows:
\enumerate{
\item The \code{dataset_ex} is filtered using \code{filter_ex}, if provided.
This is useful for, for example, filtering for valid dose only.
\item The datasets \code{dataset} and \code{dataset_ex} are joined using \code{by_vars}.
\item The last dose date is derived:
the last dose date is the maximum date where \code{dose_end} is lower to or equal to
\code{analysis_date}, subject to both date values are non-NA.
The last dose date is derived per \code{by_vars} and \code{dataset_seq_var}.
\item The last dose date is appended to the \code{dataset} and returned to the user.
}

Furthermore, the following assumption is checked: start and end dates (datetimes) need to match.
Use \code{check_dates_only} to control whether only dates or whole date-times need to be equal.
}
\examples{
library(dplyr, warn.conflicts = FALSE)
library(admiral.test)
data(admiral_ae)
data(ex_single)

admiral_ae \%>\%
  head(100) \%>\%
  derive_last_dose(
    head(ex_single, 100),
    filter_ex = (EXDOSE > 0 | (EXDOSE == 0 & grepl("PLACEBO", EXTRT))) &
      nchar(EXENDTC) >= 10,
    dose_start = EXSTDTC,
    dose_end = EXENDTC,
    analysis_date = AESTDTC,
    dataset_seq_var = AESEQ,
    new_var = LDOSEDTM,
    output_datetime = TRUE,
    check_dates_only = FALSE
  ) \%>\%
  select(STUDYID, USUBJID, AESEQ, AESTDTC, LDOSEDTM)

# or with traceability variables
admiral_ae \%>\%
  head(100) \%>\%
  derive_last_dose(
    head(ex_single, 100),
    filter_ex = (EXDOSE > 0 | (EXDOSE == 0 & grepl("PLACEBO", EXTRT))) &
      nchar(EXENDTC) >= 10,
    dose_start = EXSTDTC,
    dose_end = EXENDTC,
    analysis_date = AESTDTC,
    dataset_seq_var = AESEQ,
    new_var = LDOSEDTM,
    output_datetime = TRUE,
    check_dates_only = FALSE,
    traceability_vars = dplyr::vars(LDOSEDOM = "EX", LDOSESEQ = EXSEQ, LDOSEVAR = "EXSTDTC")
  ) \%>\%
  select(STUDYID, USUBJID, AESEQ, AESTDTC, LDOSEDTM, LDOSEDOM, LDOSESEQ, LDOSEVAR)
}
\author{
Ondrej Slama
}
\keyword{adae}
\keyword{derivation}
